/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.etc;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.assemblies.HUDConsole;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.config.Configurable;
import org.xith3d.utility.config.Configuration;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple testcase featuring the Configuration class."}, authors={"Mathias Henze (aka cylab)"})
public class ConfigurationTest
extends Xith3DTest {
    private static final LogChannel LOG_CHANNEL = new LogChannel("ConfigurationTest");
    private HUDConsole console;
    public static boolean booleanField = false;
    public static int intField = 0;
    public static String stringField = "unset";
    public static float floatField = 0.0f;
    private static boolean booleanProperty = false;
    private static int intProperty = 0;
    private static String stringProperty = "unset";
    private static float floatProperty = 0.0f;
    @Configurable
    public static float annotatedFloatField = 0.0f;
    @Configurable
    private static int annotatedIntProperty = 0;
    private static String annotatedStringSetter = "unset";
    private static float annotatedFloatGetter = 0.0f;
    private static boolean annotatedBooleanGetter = false;

    public static void setBooleanProperty(boolean booleanProperty) {
        ConfigurationTest.booleanProperty = booleanProperty;
    }

    public static void setFloatProperty(float floatProperty) {
        ConfigurationTest.floatProperty = floatProperty;
    }

    public static void setIntProperty(int intProperty) {
        ConfigurationTest.intProperty = intProperty;
    }

    public static void setStringProperty(String stringProperty) {
        ConfigurationTest.stringProperty = stringProperty;
    }

    public static void setAnnotatedIntProperty(int annotatedIntProperty) {
        ConfigurationTest.annotatedIntProperty = annotatedIntProperty;
    }

    @Configurable
    public static void setAnnotatedStringSetter(String annotatedStringSetter) {
        ConfigurationTest.annotatedStringSetter = annotatedStringSetter;
    }

    @Configurable(value={"TheAnnotatedFloat"})
    public static float getAnnotatedFloatGetter() {
        return annotatedFloatGetter;
    }

    public static void setAnnotatedFloatGetter(float annotatedFloatGetter) {
        ConfigurationTest.annotatedFloatGetter = annotatedFloatGetter;
    }

    @Configurable(value={"TheAnnotatedBoolean", "This setting will cause ConfigurationTest.setAnnotateBooleanGetter() to get called"})
    public static boolean isAnnotatedBooleanGetter() {
        return annotatedBooleanGetter;
    }

    public static void setAnnotatedBooleanGetter(boolean annotatedBooleanGetter) {
        ConfigurationTest.annotatedBooleanGetter = annotatedBooleanGetter;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createHUD(Xith3DEnvironment env, Sized2iRO resolusion) {
        HUD hud = new HUD(resolusion, 800.0f);
        HUDConsole.Description desc = new HUDConsole.Description();
        desc.setListFont(HUDFont.getFont("Courier", HUDFont.PLAIN, 12));
        this.console = new HUDConsole(hud.getResX(), 250.0f, LOG_CHANNEL.getID(), desc, true);
        this.console.setTrimMessages(false);
        hud.getContentPane().addWidget(this.console);
        this.console.setInputBoxVisible(false);
        Log.getLogManager().registerLog(this.console);
        Label info = new Label(hud.getResX(), hud.getResY(), "Configuration Test", HUDFont.getFont("Verdana", HUDFont.PLAIN, 24), Colorf.WHITE, TextAlignment.CENTER_CENTER);
        hud.getContentPane().addWidget(info);
        TestUtils.displayInputBindings(null, null, hud);
        env.addHUD(hud);
    }

    private void start() {
        Configuration configuration = new Configuration();
        configuration.register(ConfigurationTest.class, "booleanField");
        configuration.register(ConfigurationTest.class, "intField");
        configuration.register(ConfigurationTest.class, "stringField");
        configuration.register(ConfigurationTest.class, "floatField");
        configuration.register(ConfigurationTest.class, "booleanProperty");
        configuration.register(ConfigurationTest.class, "intProperty");
        configuration.register(ConfigurationTest.class, "stringProperty");
        configuration.register(ConfigurationTest.class, "floatProperty");
        configuration.register(ConfigurationTest.class);
        Log.println(LOG_CHANNEL, "Fields before loading: ");
        Log.println(LOG_CHANNEL, "  booleanField: " + booleanField);
        Log.println(LOG_CHANNEL, "  intField:     " + intField);
        Log.println(LOG_CHANNEL, "  stringField:  " + stringField);
        Log.println(LOG_CHANNEL, "  floatField:   " + floatField);
        Log.println(LOG_CHANNEL, "Properties before loading: ");
        Log.println(LOG_CHANNEL, "  booleanProperty: " + booleanProperty);
        Log.println(LOG_CHANNEL, "  intProperty:     " + intProperty);
        Log.println(LOG_CHANNEL, "  stringProperty:  " + stringProperty);
        Log.println(LOG_CHANNEL, "  floatProperty:   " + floatProperty);
        Log.println(LOG_CHANNEL, "Annotated Fields and Properties before loading: ");
        Log.println(LOG_CHANNEL, "  annotatedFloatField:    " + annotatedFloatField);
        Log.println(LOG_CHANNEL, "  annotatedIntProperty:   " + annotatedIntProperty);
        Log.println(LOG_CHANNEL, "  annotatedStringSetter:  " + annotatedStringSetter);
        Log.println(LOG_CHANNEL, "  annotatedFloatGetter:   " + annotatedFloatGetter);
        Log.println(LOG_CHANNEL, "  annotatedBooleanGetter: " + annotatedBooleanGetter);
        configuration.load("ConfigurationTest", "settings.properties");
        Log.println(LOG_CHANNEL, "Fields after loading:");
        Log.println(LOG_CHANNEL, "  booleanField: " + booleanField);
        Log.println(LOG_CHANNEL, "  intField:     " + intField);
        Log.println(LOG_CHANNEL, "  stringField:  " + stringField);
        Log.println(LOG_CHANNEL, "  floatField:   " + floatField);
        Log.println(LOG_CHANNEL, "Properties after loading:");
        Log.println(LOG_CHANNEL, "  booleanProperty: " + booleanProperty);
        Log.println(LOG_CHANNEL, "  intProperty:     " + intProperty);
        Log.println(LOG_CHANNEL, "  stringProperty:  " + stringProperty);
        Log.println(LOG_CHANNEL, "  floatProperty:   " + floatProperty);
        Log.println(LOG_CHANNEL, "Annotated Fields and Properties after loading: ");
        Log.println(LOG_CHANNEL, "  annotatedFloatField:    " + annotatedFloatField);
        Log.println(LOG_CHANNEL, "  annotatedIntProperty:   " + annotatedIntProperty);
        Log.println(LOG_CHANNEL, "  annotatedStringSetter:  " + annotatedStringSetter);
        Log.println(LOG_CHANNEL, "  annotatedFloatGetter:   " + annotatedFloatGetter);
        Log.println(LOG_CHANNEL, "  annotatedBooleanGetter: " + annotatedBooleanGetter);
    }

    public ConfigurationTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createHUD(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.start();
    }

    public static void main(String[] args) throws Throwable {
        ConfigurationTest test = new ConfigurationTest(ConfigurationTest.parseCommandLine(args));
        test.begin();
    }
}

