/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.etc;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.screenshots.ScreenshotEngine;
import org.xith3d.utility.screenshots.ScreenshotInputAction;

@Xith3DTest.Description(fulltext={"Simple testcase featuring the screenshot engine."}, authors={"Marvin Froehlich (aka Qudus)"})
public class ScreenshotTest
extends Xith3DTest
implements IntervalListener {
    private ScreenshotEngine screenshotEngine;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.screenshotEngine.takeScreenshot(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (interval.getName().equals("interval-5000")) {
            this.screenshotEngine.takeScreenshot(false);
            interval.kill();
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup sceneBranch = new BranchGroup();
        sceneBranch.addChild(new Rectangle(4.0f, 4.0f, "stone.jpg"));
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.5f));
        rg.setTranslation(0.0f, 0.0f, 1.0f);
        rg.addChild(new Rectangle(3.0f, 3.0f, "jplogo.png"));
        sceneBranch.addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
        env.addPerspectiveBranch(sceneBranch);
        this.getOperationScheduler().addInterval(new Interval(5000L, "interval-5000"));
        this.getOperationScheduler().addIntervalListener(this);
        this.screenshotEngine = env.getScreenshotEngine();
        Keys.S.bindAction(new ScreenshotInputAction(this.screenshotEngine));
    }

    public ScreenshotTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{null, Keys.SPACE, Keys.S};
        String[] boundActions = new String[]{"Automatic screenshot taken after 5s", "Take a screenshot (through \"takeScreenshot\")", "Take a screenshot (through \"ScreenshotInputAction\")"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        ScreenshotTest test = new ScreenshotTest(ScreenshotTest.parseCommandLine(args));
        test.begin();
    }
}

