/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.fog;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.ExponentialFog;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D ExponentialFog test."}, authors={"Benjamin Winters", "Marvin Froehlich (aka Qudus)"})
public class ExponentialFogTest
extends Xith3DTest {
    private final Colorf FOG_COLOR = Colorf.GRAY80;
    private final int NUM_CUBES = 60;
    private Random rnd = new Random();
    private ExponentialFog fog;
    private int fogModeIndex = ExponentialFog.FogMode.values()[0].ordinal();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.fogModeIndex = (this.fogModeIndex + 1) % ExponentialFog.FogMode.values().length;
                ExponentialFog.FogMode mode = ExponentialFog.FogMode.values()[this.fogModeIndex];
                this.fog.setFogMode(mode);
                System.out.println("Using FogMode " + (Object)((Object)mode));
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private float rand(float min, float max) {
        return this.rnd.nextFloat() * (max - min) + min;
    }

    private Group loadPlanes() {
        Group group = new Group();
        for (int i = 0; i < 60; ++i) {
            Rectangle rect = new Rectangle(2.0f, 2.0f, new Colorf(this.rand(0.0f, 1.0f), this.rand(0.0f, 1.0f), this.rand(0.0f, 1.0f)));
            StaticTransform.translate(rect, this.rand(-25.0f, 25.0f), this.rand(-25.0f, 25.0f), this.rand(-25.0f, 25.0f));
            Appearance app = rect.getAppearance(true);
            app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
            app.getColoringAttributes(true).setShadeModel(ColoringAttributes.SHADE_FLAT);
            group.addChild(rect);
        }
        return group;
    }

    private void createSceneGraph(Xith3DEnvironment env) {
        BranchGroup root = new BranchGroup();
        this.fog = new ExponentialFog(this.FOG_COLOR, 0.04f);
        root.addChild(this.fog);
        root.addChild(this.loadPlanes());
        env.addPerspectiveBranch(root);
    }

    public ExponentialFogTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 40.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(this.FOG_COLOR);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "FPS input"), Keys.SPACE};
        String[] boundActions = new String[]{"Move through the fog", "Toggle between OpenGL exponential fog algorithms (GL_EXP and GL_EXP2)"};
        TestUtils.displayInputBindings((Sized2iRO)canvas, comps, boundActions, (SceneGraph)env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        ExponentialFogTest test = new ExponentialFogTest(ExponentialFogTest.parseCommandLine(args));
        test.begin();
    }
}

