/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.actions.InputAction;
import org.jagatoo.input.actions.LabeledInputAction;
import org.jagatoo.input.actions.LabeledInvokableInputAction;
import org.jagatoo.input.devices.InputDevice;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputStatesManager;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This is a simple testcase, that demonstrates, how to", "create and use a custom InputAction in Xith3D."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CustomInputActionTest
extends Xith3DTest {
    private static RenderLoop renderLoop;
    private static RotatableGroup rotGroup;
    private InputStatesManager statesManager;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.statesManager.update(timingMode.getNanoSeconds(gameTime));
    }

    private RotatableGroup createSceneGraph(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        Sphere sphere = new Sphere(2.0f, 128, 64, "earth.jpg");
        rg.addChild(sphere);
        scene.addChild(rg);
        sceneGraph.addPerspectiveBranch(scene);
        return rg;
    }

    public CustomInputActionTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        rotGroup = this.createSceneGraph(env);
        this.getAnimator().addAnimatableObject(rotGroup, false);
        InputBindingsManager<CustomInputAction> bindingsManager = new InputBindingsManager<CustomInputAction>(CustomInputAction.values().length);
        bindingsManager.bind(Keys.SPACE, CustomInputAction.ROTATE);
        this.statesManager = new InputStatesManager(bindingsManager);
        DeviceComponent[] comps = new DeviceComponent[CustomInputAction.values().length];
        int numBindings = bindingsManager.getBoundInputComponents(comps);
        InputAction[] boundActions = new CustomInputAction[numBindings];
        bindingsManager.getBoundActions(comps, boundActions);
        TestUtils.displayInputBindings(arguments.getResolution(), comps, (LabeledInputAction[])boundActions, (SceneGraph)env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        InputSystem.getInstance().registerInputStatesManager(this.statesManager);
        renderLoop = this;
    }

    public static void main(String[] args) throws Throwable {
        CustomInputActionTest test = new CustomInputActionTest(CustomInputActionTest.parseCommandLine(args));
        test.begin();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CustomInputAction implements LabeledInvokableInputAction
    {
        ROTATE;


        @Override
        public String getText() {
            return "Rotate the sphere";
        }

        @Override
        public String getLocalizedText() {
            return this.getText();
        }

        @Override
        public String invokeAction(InputDevice device, DeviceComponent comp, int delta, int state, long nanoTime) throws InputSystemException {
            System.out.println("State changed on action " + this + ". New state: " + state + ".");
            if (state != 0) {
                rotGroup.startAnimation(renderLoop.getGameTime(), renderLoop.getTimingMode());
            } else {
                rotGroup.stopAnimation();
            }
            return "ok";
        }
    }
}

