/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.input;

import java.awt.im.InputContext;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseAxis;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.managers.InputBindingsSet;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHInputBindingsManager;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.avatar.DefaultAvatarTransform;
import org.xith3d.scenegraph.primitives.Box;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"PointAndClickTest"}, authors={"Marvin Froehlich (aka Qudus)"})
public class PointAndClickTest
extends Xith3DTest
implements NearestPickListener {
    private static final float rotationSpeed = 0.05f;
    private static final float targetDist = 3.0f;
    private Canvas3D canvas;
    private View view;
    private FirstPersonInputHandler fpih;
    private Group pickGroup;
    private Point3f pos0 = new Point3f();
    private Point3f pos1 = new Point3f();
    private Vector3f vec0 = new Vector3f();
    private Vector3f vec1 = new Vector3f();
    private float totalAngle;
    private float t0;
    private float t1;
    private Vector3f tmpVec = new Vector3f();
    private Point3f tmpPoint = new Point3f();
    private boolean isMoving = false;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        PickingLibrary.pickNearest(this.pickGroup, this.canvas, e.getButton(), e.getX(), e.getY(), (NearestPickListener)this);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        if (this.isMoving) {
            float gameSeconds = timingMode.getSecondsAsFloat(gameTime);
            float dt = gameSeconds - this.t0;
            if (gameSeconds >= this.t1) {
                dt = this.t1 - this.t0;
                this.isMoving = false;
            }
            float alpha = dt / (this.t1 - this.t0);
            this.tmpPoint.interpolate(this.pos0, this.pos1, alpha);
            this.tmpVec.interpolate(this.vec0, this.vec1, alpha);
            this.view.lookAlong(this.tmpPoint, this.tmpVec);
            this.fpih.updateViewInverse();
            if (!this.isMoving) {
                this.fpih.setKeyboardSuspended(false);
            }
        }
    }

    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        Bounds bounds = nearest.getNode().getWorldBounds();
        if (nearest.getNode().getName().equals("Point1") || nearest.getNode().getName().equals("Point2")) {
            this.view.getFacingDirection(this.vec0);
            this.view.getTransform().getTranslation(this.tmpVec);
            this.vec1.set(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
            this.vec1.sub(this.tmpVec);
            this.vec1.normalize();
            this.totalAngle = this.vec0.angle(this.vec1);
            this.t0 = this.getTimingMode().getSecondsAsFloat(this.getGameTime());
            this.t1 = this.t0 + 20.0f * this.totalAngle / ((float)Math.PI * 2);
            this.view.getTransform().getTranslation(this.pos0);
            this.tmpVec.set(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
            this.tmpVec.sub(this.pos0);
            this.tmpVec.normalize();
            this.tmpVec.scale(3.0f);
            this.pos1.set(bounds.getCenterX(), bounds.getCenterY(), bounds.getCenterZ());
            this.pos1.sub(this.tmpVec);
            this.fpih.setKeyboardSuspended(true);
            this.isMoving = true;
        }
    }

    public void onPickingMissed(Object userObject, long pickTime) {
    }

    private FirstPersonInputHandler createFPIH(View view, Sized2iRO resolution, boolean mouseYInverted, BranchGroup rootBranch) {
        FirstPersonInputHandler fpih = new FirstPersonInputHandler((Transformable)view, resolution, 1.0f, 1.0f, mouseYInverted, 1.0f);
        fpih.setThirdPersonDistance(10.0f);
        FPIHInputBindingsManager bindings = fpih.getBindingsManager();
        bindings.createDefaultBindings();
        String country = InputContext.getInstance().getLocale().getCountry();
        if (country.equals("FR") || country.equals("BE")) {
            bindings.bind(Keys.Q, FPIHInputAction.TURN_LEFT, InputBindingsSet.PRIMARY);
        } else {
            bindings.bind(Keys.A, FPIHInputAction.TURN_LEFT, InputBindingsSet.PRIMARY);
        }
        bindings.bind(Keys.D, FPIHInputAction.TURN_RIGHT, InputBindingsSet.PRIMARY);
        fpih.setMouseSuspended(true);
        Box avatar = new Box(1.0f, 10.0f, 1.0f, Colorf.GREEN);
        StaticTransform.translate(avatar, 0.0f, 5.0f, 0.0f);
        fpih.addAvatar(new DefaultAvatarTransform((Node)avatar, -10.0f, rootBranch));
        return fpih;
    }

    private Group createPickPoints() {
        Group group = new Group();
        Geometry s0 = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 1.0f, 16, 16, 1, false, 2);
        Appearance app = new Appearance();
        app.setColor(Colorf.RED);
        Shape3D s1 = new Shape3D(s0, app);
        s1.setName("Point1");
        TransformGroup tg1 = new TransformGroup(-10.0f, 10.0f, -10.0f);
        tg1.addChild(s1);
        group.addChild(tg1);
        Shape3D s2 = new Shape3D(s0, app);
        s2.setName("Point2");
        TransformGroup tg2 = new TransformGroup(10.0f, 10.0f, -10.0f);
        tg2.addChild(s2);
        group.addChild(tg2);
        this.pickGroup = group;
        return group;
    }

    private BranchGroup createSceneGraph() {
        BranchGroup scene = new BranchGroup();
        Rectangle floor = new Rectangle(100.0f, 100.0f, "grass.jpg");
        StaticTransform.rotateX(floor, -1.5707964f);
        floor.setPickable(false);
        scene.addChild(floor);
        scene.addChild(this.createPickPoints());
        return scene;
    }

    public PointAndClickTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 10.25f, 10.0f, 0.0f, 10.25f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.view = env.getView();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.useAsSingletonInstance();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph();
        env.addPerspectiveBranch(rootBranch);
        this.fpih = this.createFPIH(env.getView(), arguments.getResolution(), arguments.getMouseYInverted(), rootBranch);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        DeviceComponent[] comps = new DeviceComponent[]{new MouseAxis(null, 'm', "FPS input"), MouseButtons.LEFT_BUTTON};
        String[] boundActions = new String[]{"Move in the scene", "Go to the pointed sphere"};
        TestUtils.displayInputBindings((Sized2iRO)this.canvas, comps, boundActions, (SceneGraph)env);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        InputSystem.getInstance().addInputHandler(this.fpih);
    }

    public static void main(String[] args) throws Throwable {
        PointAndClickTest test = new PointAndClickTest(PointAndClickTest.parseCommandLine(args));
        test.begin();
    }
}

