/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.lighting;

import java.awt.Font;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Disk;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.text2d.Character2D;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This is a test for dynamic lighting.<br>", "\"Dynamic\" means, that lights can be switched on and off and can be removed", "and readded to the scenegraph."}, authors={"Marvin Froehlich (aka Qudus)"})
public class DynamicLightsTest
extends Xith3DTest {
    private static final int NUM_LIGHTS = 8;
    private static final Font CHAR_FONT = new Font("Verdana", 1, 128);
    private final Group[] lightGroups = new Group[8];
    private final Light[] lights = new Light[8];

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case _1: 
            case _2: 
            case _3: 
            case _4: 
            case _5: 
            case _6: 
            case _7: 
            case _8: {
                boolean shiftPressed = (e.getKeyboard().getModifierMask() & 1) != 0;
                int lightIndex = key.getKeyCode() - Keys._1.getKeyCode();
                Light l = this.lights[lightIndex];
                if (!shiftPressed) {
                    l.setEnabled(!l.isEnabled());
                    System.out.println((l.isEnabled() ? "enabled" : "disabled") + " light #" + lightIndex);
                    break;
                }
                if (l.getParent() != null) {
                    this.lightGroups[lightIndex].removeChild(l);
                } else {
                    this.lightGroups[lightIndex].addChild(l);
                }
                System.out.println((l.getParent() == null ? "removed" : "added") + " light #" + lightIndex);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, Sized2iRO resolution, Animator animator) {
        Character2D.setFontStretchFactor(2.0f / resolution.getAspect() / (float)resolution.getHeight());
        Material lightenedMat = new Material();
        lightenedMat.setEmissiveColor(Colorf.GRAY80);
        lightenedMat.setColorTarget(Material.NONE);
        lightenedMat.setLightingEnabled(true);
        BranchGroup root = new BranchGroup();
        TransformGroup tg_lights = new TransformGroup();
        tg_lights.getTransform().setTranslation(0.0f, 0.0f, -1.0f);
        root.addChild(tg_lights);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.05f));
        tg_lights.addChild(rg);
        for (int i = 0; i < 8; ++i) {
            TransformGroup tg_lighti_rot = new TransformGroup();
            tg_lighti_rot.getTransform().rotZ((float)i * 0.125f * ((float)Math.PI * 2));
            TransformGroup tg_lighti_trans = new TransformGroup();
            tg_lighti_trans.getTransform().setTranslation(2.5f, 0.0f, 0.0f);
            tg_lighti_rot.addChild(tg_lighti_trans);
            this.lightGroups[i] = tg_lighti_trans;
            this.lights[i] = new DirectionalLight(true, new Colorf(0.45f, 0.3f, 0.7f), Vector3f.NEGATIVE_Z_AXIS);
            tg_lighti_trans.addChild(this.lights[i]);
            Character2D chari = Character2D.loadCharacter((char)(i + 49), Colorf.GREEN, CHAR_FONT);
            StaticTransform.translate(chari, -chari.getWidth() / 2.0f, chari.getHeight() / 2.0f, 0.0f);
            tg_lighti_trans.addChild(chari);
            Disk disk = new Disk(64, 3, false, 2);
            StaticTransform.scale(disk, 0.5f);
            StaticTransform.translate(disk, 0.0f, 0.0f, -0.1f);
            Appearance app = new Appearance();
            app.setMaterial(lightenedMat);
            disk.setAppearance(app);
            tg_lighti_trans.addChild(disk);
            rg.addChild(tg_lighti_rot);
        }
        env.addBranchGraph(root, new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION));
        animator.addAnimatableObject(rg);
    }

    public DynamicLightsTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, arguments.getResolution(), this.getAnimator());
        System.out.println("Hit 1-8 to switch Lights on and off, Hit Shift+1-8 to add/remove Lights, or ESC to exit");
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.BLACK);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        DynamicLightsTest test = new DynamicLightsTest(DynamicLightsTest.parseCommandLine(args));
        test.begin();
    }
}

