/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.lighting;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.ShaderProgramContext;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Grid;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple View attached SpotLight testcase"}, authors={"Marvin Froehlich (aka Qudus)"})
public class ViewSpotlightTest
extends Xith3DTest {
    private Canvas3D canvas;
    private SpotLight light;
    private Material mat;
    private ShaderProgramContext<?> shaderProgram;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case P: {
                this.shaderProgram.setEnabled(!this.shaderProgram.isEnabled());
                break;
            }
            case L: {
                this.light.setEnabled(!this.light.isEnabled());
                break;
            }
            case SPACE: {
                this.mat.setLightingEnabled(!this.mat.isLightingEnabled());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onKeyStateChanged(KeyStateEvent e, Key key, boolean state) {
        switch (key.getKeyID()) {
            case T: {
                this.canvas.getRenderOptions().setGLTracingEnabled(state);
            }
        }
    }

    private void createSceneGraph(ResourceLocator resLoc, Xith3DEnvironment env) throws Exception {
        BranchGroup scene = new BranchGroup();
        this.light = new SpotLight(true, Colorf.WHITE, (Tuple3f)new Point3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Tuple3f(1.0f, 0.2f, 0.08f), FastMath.toRad(20.0f), 1.0f);
        this.mat = new Material();
        this.mat.setEmissiveColor(Colorf.BLACK);
        this.mat.setSpecularColor(Colorf.GRAY50);
        this.mat.setAmbientColor(Colorf.GRAY25);
        this.mat.setDiffuseColor(Colorf.GRAY25);
        this.mat.setLightingEnabled(true);
        GLSLContext.setDebuggingEnabled(true);
        GLSLContext shaderProgram = new GLSLContext(new GLSLShaderProgram());
        GLSLShaderLoader loader = GLSLShaderLoader.getInstance();
        ((GLSLShaderProgram)shaderProgram.getProgram()).addShader(loader.loadVertexShader(resLoc.getResource("shader/lighting/per-pixel-lighting.vertex.glsl")));
        ((GLSLShaderProgram)shaderProgram.getProgram()).addShader(loader.loadFragmentShader(resLoc.getResource("shader/lighting/per-pixel-lighting.fragment.glsl")));
        shaderProgram.getUniformParameters().setUniformVar("texture0", 0);
        Sphere sphere = new Sphere(1.0f, 32, 16, "deathstar.jpg");
        sphere.getAppearance(true).setMaterial(this.mat);
        sphere.getAppearance().setShaderProgramContext(shaderProgram);
        scene.addChild(sphere);
        Grid rect = new Grid(10.0f, 10.0f, 32, 32, "stone.jpg");
        StaticTransform.rotateY(rect, 0.7853982f);
        StaticTransform.translate(rect, -5.0f, 0.0f, 0.0f);
        rect.getAppearance(true).setMaterial(this.mat);
        rect.getAppearance().setShaderProgramContext(shaderProgram);
        scene.addChild(rect);
        rect = new Grid(10.0f, 10.0f, 32, 32, "rustycan.jpg");
        StaticTransform.rotateY(rect, -0.7853982f);
        StaticTransform.translate(rect, 5.0f, 0.0f, 0.0f);
        rect.getAppearance(true).setMaterial(this.mat);
        rect.getAppearance().setShaderProgramContext(shaderProgram);
        scene.addChild(rect);
        this.shaderProgram = shaderProgram;
        env.addPerspectiveBranch(scene);
        env.getView().setAttachedLight(this.light);
    }

    public ViewSpotlightTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(ResourceLocator.create("test-resources/"), env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpHandler = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)this.canvas, arguments.getMouseYInverted());
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpHandler);
        System.out.println("Press P to enable/disable the per-pixel-lighting-ShaderProgram.");
        System.out.println("Press L to enable/disable the View-attached-SpotLight.");
        System.out.println("Press SPACE to enable/disable the lighting-Material.");
        Thread.yield();
    }

    public static void main(String[] args) throws Throwable {
        ViewSpotlightTest test = new ViewSpotlightTest(ViewSpotlightTest.parseCommandLine(args));
        test.begin();
    }
}

