/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.loaders.util.RotatingModel;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A simple test example to load up an AC3D model."}, authors={"Marvin Froehlich (aka Qudus)"})
public class AC3DLoaderTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void loadModel(ResourceLocator resLoc, Xith3DEnvironment env, Animator animator) throws Exception {
        Model model = ModelLoader.getInstance().loadModel(resLoc.getResource("models/Bass.ac"));
        RotatingModel rotModel = new RotatingModel(model, 20.0f);
        BranchGroup root = new BranchGroup();
        root.addChild(new PointLight(1.0f, 0.8f, 0.2f, 2.0f, 2.0f, 15.0f, 0.001f));
        root.addChild(rotModel);
        env.addPerspectiveBranch(root).getConfig().setOpaqueSorter(null);
        animator.addAnimatableObject(rotModel);
    }

    public AC3DLoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(5.0f, 1.0f, 80.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.loadModel(resLoc, env, this.getAnimator());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        AC3DLoaderTest test = new AC3DLoaderTest(AC3DLoaderTest.parseCommandLine(args));
        test.begin();
    }
}

