/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.util.Map;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.KeyFrameController;
import org.xith3d.loaders.models.animations.MeshTransformKeyFrameController;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.models.util.animations.AnimationTools;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test of the Xith3D ASE Loader's animation capabilities."}, authors={"Marvin Froehlich (aka Qudus)"})
public class AseAnimationTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createAnimation(Model model) {
        Map<String, NamedObject> namedObjects = model.getNamedObjects();
        TransformGroup root = (TransformGroup)namedObjects.get("MasterRoot");
        TransformGroup group = (TransformGroup)namedObjects.get("Group01");
        TransformGroup box1 = (TransformGroup)namedObjects.get("Box01");
        TransformGroup box2 = (TransformGroup)namedObjects.get("Box02");
        int numFrames = 100;
        KeyFrameController[] controllers = new MeshTransformKeyFrameController[]{AnimationTools.createRotationalKeyFrameController(Vector3f.POSITIVE_Y_AXIS, false, numFrames, root), AnimationTools.createRotationalKeyFrameController(Vector3f.POSITIVE_Y_AXIS, 0.0f, (float)Math.PI * 6, true, numFrames, group), AnimationTools.createRotationalKeyFrameController(Vector3f.POSITIVE_Y_AXIS, false, numFrames, box1), AnimationTools.createRotationalKeyFrameController(Vector3f.POSITIVE_Y_AXIS, false, numFrames, box2)};
        ModelAnimation animation = new ModelAnimation("default", numFrames, 25.0f, controllers);
        model.setAnimations(new ModelAnimation[]{animation});
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup scene = new BranchGroup();
        int flags = ModelLoader.getInstance().getFlags() & 0xFFFFFFDF;
        Model model = ModelLoader.getInstance().loadModel(resLoc.getResource("models/rotatingcubetest.ASE"), 1.0f, flags);
        scene.addChild(model);
        this.createAnimation(model);
        model.setCurrentAnimation(0);
        scene.addChild(ModelLoader.getInstance().loadModel(resLoc.getResource("models/origincube.ASE")));
        env.addPerspectiveBranch(scene);
    }

    public AseAnimationTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(-250.0f, 150.0f, -150.0f, -0.0f, 0.0f, 150.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit ESC to exit\nPress 1 to toggle cube rotating, 2 to toggle group rotating and 3 to toggle scene rotating");
    }

    public static void main(String[] args) throws Throwable {
        AseAnimationTest test = new AseAnimationTest(AseAnimationTest.parseCommandLine(args));
        test.begin();
    }
}

