/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import java.io.IOException;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.openmali.FastMath;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHPhysics;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.util.specific.bsp.CollisionEnabledClusterManager;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.PickScheduler;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BSPTreeGroup;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.utility.camera.flight.CameraFlight;
import org.xith3d.utility.camera.flight.CameraFlightListener;
import org.xith3d.utility.camera.flight.CameraFlightRecorder;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"An extended test of the BSPLoader including physics."}, authors={"David Yazel", "Marvin Froehlich (aka Qudus)"})
public class BSPLoaderTest
extends Xith3DTest
implements CameraFlightListener,
PickListener {
    private static final boolean DEBUG = true;
    private CollisionEnabledClusterManager clusterManager;
    private View view;
    private Canvas3D canvas;
    private FirstPersonInputHandler fpHandler;
    private CameraFlightRecorder flightRecorder = null;
    private CameraFlight camFlight = null;
    private PickScheduler pickScheder;
    private GroupNode scene;
    private CollisionEngine collEngine;
    private SimulationWorld world;

    @Override
    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        super.onRenderLoopStopped(gameTime, timingMode, averageFPS);
        System.out.println("average FPS: " + averageFPS);
    }

    @Override
    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F4: {
                if (this.clusterManager == null) break;
                this.clusterManager.setPVSUsage(!this.clusterManager.isPVSUsed());
                System.out.println("PVS: " + (this.clusterManager.isPVSUsed() ? "on" : "off"));
                break;
            }
            case C: {
                this.collEngine.setEnabled(!this.collEngine.isEnabled());
                break;
            }
            case G: {
                this.world.setGravityEnabled(!this.world.isGravityEnabled());
                break;
            }
            case BACK_SPACE: {
                this.view.lookAlong(-13.3f, 3.5f, -2.0f, 1.0f, 0.0f, 0.0f);
                this.fpHandler.updateViewInverse();
                break;
            }
            case V: {
                this.canvas.getPeer().setVSyncEnabled(!this.canvas.getPeer().isVSyncEnabled());
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
            }
        }
    }

    @Override
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F9: {
                if (this.flightRecorder == null) {
                    this.flightRecorder = new CameraFlightRecorder(this.view, 100L);
                    this.getOperationScheduler().addInterval(this.flightRecorder);
                    this.getOperationScheduler().addIntervalListener(this.flightRecorder);
                    this.flightRecorder.startRecord(this.getGameMicroTime(), "camflight.cflt", CameraFlight.Format.COMPRESSED);
                    break;
                }
                this.flightRecorder.stopRecord();
                this.getOperationScheduler().removeIntervalListener(this.flightRecorder);
                this.flightRecorder.kill();
                this.flightRecorder = null;
                break;
            }
            case F10: {
                if (this.camFlight == null) {
                    try {
                        this.fpHandler.setSuspended(true);
                        long t0 = System.currentTimeMillis();
                        this.camFlight = new CameraFlight(ResourceLocator.getInstance().getResource("pdmq3duel5/inter_engine_benchmark--2006-09-29.cflt"));
                        this.camFlight.addCameraFlightListener(this);
                        this.camFlight.start(this.getGameMicroTime() + (System.currentTimeMillis() - t0));
                        System.out.println("CameraFlight started.");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                this.camFlight = null;
                this.fpHandler.updateViewInverse();
                this.fpHandler.setSuspended(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    @Override
    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        if (button == MouseButtons.LEFT_BUTTON) {
            this.pickScheder.pickNearest(this.scene, e.getButton(), this.canvas.getWidth() / 2, this.canvas.getHeight() / 2, (NearestPickListener)this);
        } else {
            this.pickScheder.pickAll(this.scene, e.getButton(), this.canvas.getWidth() / 2, this.canvas.getHeight() / 2, (AllPickListener)this);
        }
    }

    private void blink(final Shape3D shape, final boolean continuous) {
        shape.setRenderable(false);
        this.getOperationScheduler().addInterval(new Interval(this.getTimingMode().getFromMilliSeconds(1000L)){

            protected void onIntervalHit(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                shape.setRenderable(!shape.isRenderable());
                if (!continuous) {
                    this.kill();
                }
            }
        });
    }

    @Override
    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        Shape3D shape = (Shape3D)nearest.getNode();
        System.out.println(shape.getAppearance().getTexture());
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        for (int i = 0; i < pickResults.size(); ++i) {
            PickResult pr = pickResults.get(i);
            pr.getNode().setShowBounds(true);
            this.blink((Shape3D)pr.getNode(), true);
        }
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("Nothing was picked!");
    }

    @Override
    public void onCameraFlightEnded(long frames, long millis, float averageFPS) {
        System.out.println("CameraFlight ended. (average FPS: " + averageFPS + ")");
    }

    @Override
    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.camFlight != null) {
            this.camFlight.updateCamera(this.view, gameTime, timingMode);
        }
        super.prepareNextFrame(gameTime, frameTime, timingMode);
    }

    private RenderPass loadLevel(CollisionEngine collEngine, SceneGraph sceneGraph) throws Exception {
        ResourceLocator resLoc = ResourceLocator.getInstance();
        Model scene = ModelLoader.getInstance().loadModel(resLoc.getResource("quake3/pdmq3duel5/pdmq3duel5.bsp"));
        if (scene.getMainGroup() instanceof BSPTreeGroup) {
            BSPTreeGroup bspTG = (BSPTreeGroup)scene.getMainGroup();
            this.clusterManager = new CollisionEnabledClusterManager((BSPClusterManager)bspTG.getBSPVisibilityUpdater(), scene, collEngine);
            bspTG.setBSPVisibilityUpdater(this.clusterManager);
            this.clusterManager.setPVSUsage(false);
        }
        this.scene = scene;
        if (scene.getSpawnTransformsCount() > 0) {
            int i = FastMath.randomInt(scene.getSpawnTransformsCount());
            sceneGraph.getView().getTransform().set(scene.getSpawnTransform(i));
        }
        if (scene.getSkyBox() != null) {
            sceneGraph.addRenderPass(scene.getSkyBox());
        }
        RenderPass renderPass = sceneGraph.addPerspectiveBranch(new BranchGroup((Node)scene));
        return renderPass;
    }

    private void createInputBindingsHUD(HUD hud) {
        DeviceComponent[] comps = new DeviceComponent[]{Keys.F4, Keys.F9, Keys.F10, Keys.C, Keys.G, Keys.BACK_SPACE, Keys.V, Keys.Y, Keys.ESCAPE};
        String[] descriptions = new String[]{"Toggle PVS", "Start/Stop camera flight recorder", "Start/Stop camera flight", "Toggle collision-detection", "Toggle gravity", "Reset player", "Toggle v-sync", "Toggle Mouse-Y-flip", "Exit"};
        TestUtils.displayInputBindings(comps, descriptions, hud);
    }

    private RenderPass createSceneGraph(Xith3DEnvironment env, CollisionEngine collEngine, HUD hud) throws Exception {
        RenderPass rp = this.loadLevel(collEngine, env);
        rp.getConfig().setFrontClipDistance(0.5f);
        rp.getConfig().setBackClipDistance(6000.0f);
        rp.setClipperEnabled(false);
        rp.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        this.pickScheder = env.getPickScheduler();
        this.createInputBindingsHUD(hud);
        return rp;
    }

    private final void createFPIH(boolean mouseYInverted, PhysicsEngine physEngine, CollideableGroup levelGroup) {
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.view, this.canvas, 1.0f, 1.0f, mouseYInverted, 1.0f);
        this.fpHandler.getMovementConstraints().setFixedPlaneEnabled(true);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(FPIHInputAction.CROUCH);
        this.collEngine = physEngine.getCollisionEngine();
        this.world = physEngine.getSimulationEngine().newWorld();
        this.world.setGravity(0.0f, -9.81f, 0.0f);
        this.fpHandler.setPhysicsObject(new FPIHPhysics(1.5f, 3.0f, new Vector3f(0.0f, -1.1f, 0.0f), physEngine, this.world, true, true));
        this.scene.addChild(this.fpHandler.getPhysicsObject().getDebugNode());
        this.fpHandler.getPhysicsObject().setSlidingColliderCheckCallback(physEngine.getCollisionEngine(), levelGroup);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
    }

    public BSPLoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.view = env.getView();
        this.view.lookAlong(-13.3f, 3.5f, -2.0f, 1.0f, 0.0f, 0.0f);
        JoodePhysicsEngine physEngine = new JoodePhysicsEngine();
        env.setPhysicsEngine(physEngine);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        ResourceLocator.setSingletonInstance(resLoc.getSubLocator("levels/"));
        HUD hud = new HUD(arguments.getResolution(), 800.0f);
        this.createSceneGraph(env, physEngine.getCollisionEngine(), hud);
        CollideableGroup levelCollGroup = this.clusterManager != null ? this.clusterManager.getCollideableGroup() : null;
        resLoc.createAndAddTSL("HUD");
        hud.setCrosshair("CrosshairWhite.png");
        env.addHUD(hud);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        this.canvas = canvas;
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.createFPIH(arguments.getMouseYInverted(), physEngine, levelCollGroup);
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public static void main(String[] args) throws Throwable {
        BSPLoaderTest test = new BSPLoaderTest(BSPLoaderTest.parseCommandLine(args));
        test.begin();
    }
}

