/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.impl.cal3d.Cal3dLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"A simple test example to load up a Cal3D model"}, authors={"Amos Wenger (aka BlueSky)"})
public class Cal3DLoaderTest
extends Xith3DTest {
    private Xith3DEnvironment env;
    private Model model;
    private Light light;
    private AngleInterpolater lightAngle = new AngleInterpolater(0.0f, 1.0f, 0.0f, (float)Math.PI * 2, true);

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.lightAngle.startIncreasing(0L);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
    }

    private Group loadModel(ResourceLocator resLoc) {
        Group group = new Group();
        group.addChild(new AmbientLight(Colorf.GRAY50));
        try {
            this.model = new Cal3dLoader().loadModel(resLoc.getResource("models/cal3d/archer/Archer.cfg"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        group.addChild(new Transform().addRotationX(-1.5707964f).add(this.model));
        this.model.setCurrentAnimation(0);
        return group;
    }

    private Group createFloor() {
        Rectangle floor = new Rectangle(6.0f, 6.0f, "stratagemProject.png");
        Material mat = new Material(true);
        mat.setColorTarget(Material.NONE);
        mat.setShininess(1.0f);
        mat.setAmbientColor(new Colorf(0.99609375f, 0.99609375f, 0.99609375f));
        mat.setDiffuseColor(new Colorf(0.99609375f, 0.99609375f, 0.99609375f));
        mat.setEmissiveColor(new Colorf(0.0f, 0.0f, 0.0f));
        mat.setSpecularColor(new Colorf(0.99609375f, 0.99609375f, 0.99609375f));
        floor.getAppearance().setMaterial(mat);
        return new Transform(floor).setTranslationY(-0.7f).addRotationX(-90.0f);
    }

    protected void init(Xith3DEnvironment env) throws Exception {
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("skyboxes");
        BranchGroup rootBranch = new BranchGroup();
        this.light = new PointLight(Colorf.WHITE, (Tuple3f)new Point3f(2.0f, 5.0f, 0.0f), 3.0E-4f);
        rootBranch.addChild(this.light);
        rootBranch.addChild(this.loadModel(resLoc));
        rootBranch.addChild(this.createFloor());
        env.addPerspectiveBranch(rootBranch);
    }

    public Cal3DLoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        this.env = new Xith3DEnvironment(-1.0f, 4.0f, 6.0f, 0.0f, 2.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.init(this.env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        Cal3DLoaderTest test = new Cal3DLoaderTest(Cal3DLoaderTest.parseCommandLine(args));
        test.begin();
    }
}

