/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders;

import javax.swing.JOptionPane;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.impl.dae.DaeLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Small test for the COLLADA Loader (made for and from Blender-exported models)."}, authors={"Amos Wenger (aka BlueSky)", "Marvin Froehlich (aka Qudus)"})
public class DaeLoaderTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void loadModel(ResourceLocator resLoc, SceneGraph sg, Animator animator) throws Exception {
        BranchGroup scene = new BranchGroup();
        Object[] models = new String[]{"models/collada/fantassin_cape/fantassin_cape.dae", "models/collada/match/match-animated-translate.dae", "models/collada/match/match-animated-rotate.dae", "models/collada/match/match-animated-scale.dae", "models/collada/match/match-animated-all_at_once.dae"};
        String modelSelect = (String)JOptionPane.showInputDialog(null, "Choose a model to display", "Model selection", 1, null, models, models[0]);
        if (modelSelect == null) {
            this.end();
        }
        long t0 = TestUtils.dumpAction("Loading COLLADA model \"" + modelSelect + "\"...");
        Model model = new DaeLoader().loadModel(resLoc.getResource(modelSelect));
        TestUtils.dumpDoneIn(t0);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.05f));
        animator.addAnimatableObject(rg);
        rg.addChild(model);
        scene.addChild(rg);
        rg.setScale(1.0f / rg.getBounds().getMaxCenterDistance());
        scene.addChild(new PointLight(1.0f, 1.0f, 1.0f, -1.0f, 4.0f, 2.0f, 8.0E-5f));
        sg.addPerspectiveBranch(scene);
    }

    public DaeLoaderTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(1.0f, 1.0f, 1.5f, 0.0f, 0.0f, 0.9f, 0.0f, 0.0f, 1.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.loadModel(resLoc, env, this.getAnimator());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        DaeLoaderTest test = new DaeLoaderTest(DaeLoaderTest.parseCommandLine(args));
        test.begin();
    }
}

