/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.loaders.util;

import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Group;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;

public class RotatingModel
extends RotatableGroup {
    private final DirectionalLight direcLight;
    private final Vector3f lightDir = new Vector3f();

    public boolean animate(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (super.animate(gameTime, frameTime, timingMode)) {
            long micros = timingMode.getMicroSeconds(gameTime);
            this.lightDir.setX(-FastMath.cos(this.getRotationValue(TransformationDirectives.Axes.Y_AXIS, micros)));
            this.lightDir.setZ(FastMath.sin(this.getRotationValue(TransformationDirectives.Axes.Y_AXIS, micros)));
            this.direcLight.setDirection(this.lightDir);
            return true;
        }
        return false;
    }

    public RotatingModel(Group modelGroup, float scale, TransformationDirectives rotDirecs) {
        super(rotDirecs);
        this.direcLight = new DirectionalLight(true, Colorf.WHITE, Vector3f.POSITIVE_Z_AXIS);
        this.addChild(new AmbientLight(true, Colorf.GRAY50));
        this.addChild(this.direcLight);
        this.addChild(modelGroup);
        this.setScale(scale);
    }

    public RotatingModel(Group modelGroup, float scale) {
        this(modelGroup, scale, new TransformationDirectives(0.1f, 0.1f, 0.0f));
    }
}

