/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.ArrayList;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.collideable.PlaneCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A small example of boxes dropping on a tilted plane."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BoxDropTest
extends Xith3DTest {
    private PhysicsEngine physEng;
    private ArrayList<Body> movingObjects = new ArrayList();
    private ArrayList<Point3f> originalPositions = new ArrayList();
    private ArrayList<Vector3f> originalVelocities = new ArrayList();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.physEng.isEnabled()) {
                    for (int i = 0; i < this.movingObjects.size(); ++i) {
                        Body body = this.movingObjects.get(i);
                        body.setPosition(this.originalPositions.get(i));
                        body.setLinearVelocity(this.originalVelocities.get(i));
                        body.resetAngularVelocity();
                        body.setRotationMatrix(Matrix3f.IDENTITY);
                    }
                    break;
                }
                this.physEng.setEnabled(true);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void addMovingObject(Body body) {
        this.movingObjects.add(body);
        this.originalPositions.add(new Point3f(body.getPosition()));
        this.originalVelocities.add(new Vector3f(body.getLinearVelocity()));
    }

    private void setupPhysicsAndScene(Xith3DEnvironment sceneGraph) {
        JoodePhysicsEngine physEng = new JoodePhysicsEngine();
        CollisionEngine collEng = physEng.getCollisionEngine();
        SimulationEngine simEng = physEng.getSimulationEngine();
        SimulationWorld simWorld = simEng.newWorld();
        simWorld.setGravity(0.0f, -9.81f, 0.0f);
        physEng.getDefaultSurfaceParameters().setParameter("mu", Float.valueOf(10.0f));
        PhysicsGFXManager gfxManager = physEng.getGFXManager();
        BranchGroup scene = sceneGraph.addPerspectiveBranch().getBranchGroup();
        CollideableGroup environment = collEng.newGroup();
        PlaneCollideable ground = collEng.newPlane(0.0f, 1.0f, 0.0f, 0.0f);
        PlaneCollideable.setDefaultAppearance("grass.jpg");
        gfxManager.directAdd(ground, (GroupNode)scene);
        environment.addCollideable(ground);
        BoxCollideable ramp = collEng.newBox(2.0f, 3.0f, 5.0f);
        ramp.setRotationX(FastMath.toRad(15.0f));
        ramp.setPositionY(-0.7f);
        BoxCollideable.setDefaultAppearance("brushedMetal.png");
        gfxManager.directAdd(ramp, (GroupNode)scene);
        environment.addCollideable(ramp);
        BoxCollideable.setDefaultAppearance("crate.png");
        BoxCollideable brick0 = collEng.newBox(1.0f, 1.0f, 1.0f);
        Body brick0Body = simWorld.newBody();
        brick0Body.setMass(20.0f);
        brick0Body.setPositionY(5.0f);
        brick0Body.setPositionZ(-1.0f);
        brick0Body.addCollideable(brick0);
        simWorld.addBody(brick0Body);
        scene.addChild(gfxManager.add(brick0));
        environment.addCollideable(brick0);
        this.addMovingObject(brick0Body);
        physEng.addCollisionResolver(new CollisionResolver(environment));
        physEng.setEnabled(false);
        sceneGraph.setPhysicsEngine(physEng);
        this.physEng = physEng;
    }

    private HUD createInfoHUD(Sized2iRO size) {
        HUD hud = new HUD(size, 800.0f);
        Label info = new Label(hud.getResX(), 40.0f, "Press SPACE to (re-)start the simulation.", HUDFont.getFont("Verdana", HUDFont.PLAIN, 18), Colorf.WHITE, TextAlignment.CENTER_LEFT);
        info.setPadding(10);
        hud.getContentPane().addWidget(info, 0.0f, hud.getResY() - info.getHeight());
        return hud;
    }

    public BoxDropTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("phong");
        this.setupPhysicsAndScene(env);
        env.addHUD(this.createInfoHUD(arguments.getResolution()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to start/reset the simulation, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        BoxDropTest test = new BoxDropTest(BoxDropTest.parseCommandLine(args));
        test.begin();
    }
}

