/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.BoxCollideable;
import org.xith3d.physics.collision.collideable.SphereCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.traversal.impl.ShapeFinder;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.text2d.TextAlignment;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A small example to show how Rotation work in XPAL."}, authors={"Amos Wenger (aka BlueSky)"})
public class PhysicRotationTest
extends Xith3DTest {
    private PhysicsEngine physEng;
    private Collideable ground;
    private float groundRot = 0.0f;
    private Body body;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.physEng.setEnabled(true);
                this.body.setPosition(0.0f, 2.0f, 0.0f);
                this.body.resetLinearVelocity();
                this.body.resetAngularVelocity();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
        try {
            e.getMouse().setAbsolute(!state);
        }
        catch (InputSystemException ex) {
            ex.printStackTrace();
        }
    }

    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
        this.groundRot -= FastMath.toRad((float)dx * 0.5f);
        this.ground.setRotation(0.0f, 0.0f, this.groundRot);
    }

    private void setupPhysicsAndScene(BranchGroup scene) {
        JoodePhysicsEngine physEng = new JoodePhysicsEngine();
        CollisionEngine colEng = physEng.getCollisionEngine();
        SimulationEngine simEng = physEng.getSimulationEngine();
        SimulationWorld simWorld = simEng.newWorld();
        simWorld.setStepSize(1000L);
        simWorld.setGravity(0.0f, -9.81f, 0.0f);
        PhysicsGFXManager gfxManager = physEng.getGFXManager();
        this.ground = colEng.newBox(5.0f, 0.3f, 1.0f);
        gfxManager.directAdd(this.ground, (GroupNode)scene);
        this.ground.setPositionY(-1.8f);
        this.body = simWorld.newBody();
        this.body.setPosition(0.0f, 2.0f, 0.0f);
        this.body.setParameter("mass", Float.valueOf(120.0f));
        this.body.setRotationY(FastMath.toRad(15.0f));
        simWorld.addBody(this.body);
        SphereCollideable sphere = colEng.newSphere(0.2f);
        this.body.addCollideable(sphere);
        gfxManager.directAdd(sphere, (GroupNode)scene);
        BoxCollideable box2 = colEng.newBox(0.5f, 0.1f, 0.5f);
        this.body.addCollideable(box2);
        gfxManager.directAdd(box2, (GroupNode)scene);
        physEng.addCollisionResolver(new CollisionResolver(this.body, this.ground));
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                PhysicRotationTest.this.body.setPositionZ(0.0f);
            }
        });
        scene.addChild(new PointLight(Colorf.RED, (Tuple3f)new Point3f(15.0f, 10.0f, 0.0f), 0.005f));
        scene.addChild(new PointLight(Colorf.GREEN, (Tuple3f)new Point3f(-15.0f, 10.0f, 0.0f), 0.005f));
        scene.addChild(new PointLight(Colorf.BLUE, (Tuple3f)new Point3f(0.0f, -10.0f, 0.0f), 0.005f));
        for (Shape3D shape : ShapeFinder.findAllShapes(scene)) {
            shape.getAppearance().getMaterial(true).setLightingEnabled(true);
        }
        physEng.setEnabled(false);
        this.addUpdatable(physEng);
        this.physEng = physEng;
        physEng.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(0.0f));
    }

    private void setupHUD(Sized2iRO resolution, SceneGraph sg) {
        HUD hud = new HUD(resolution);
        hud.getContentPane().addWidget(new Label(hud.getResX(), hud.getResY(), "Rotation in XPAL example", HUDFont.getFont("ARIAL", HUDFont.BOLD, 40), Colorf.WHITE, TextAlignment.TOP_CENTER));
        hud.getContentPane().addWidget(new Label(hud.getResX(), 540.0f, "Drag the mouse around to rotate the cube,\nhit space to throw the ball again.\nOh, and don't forget to look at the code. Thank you for all.", HUDFont.getFont("ARIAL", HUDFont.ITALIC, 18), Colorf.GREEN, TextAlignment.BOTTOM_CENTER));
        sg.addHUD(hud);
    }

    public PhysicRotationTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        RenderPass perspBranch = env.addPerspectiveBranch();
        BranchGroup scene = perspBranch.getBranchGroup();
        this.setupPhysicsAndScene(scene);
        this.setupHUD(arguments.getResolution(), env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        PhysicRotationTest test = new PhysicRotationTest(PhysicRotationTest.parseCommandLine(args));
        test.begin();
    }
}

