/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.ObjectRotationInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.render.Canvas3D;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.scenegraph.primitives.Torus;
import org.xith3d.test.Xith3DTest;
import org.xith3d.ui.text2d.Text2D;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates a simple physics", "simulation with gravity and collisions."}, authors={"Thomas Welsch (aka ttww)"})
public class SimpleSimulationTest
extends Xith3DTest {
    private Xith3DEnvironment env;
    private Point3f camera;
    private Canvas3D canvas;
    private TransformGroup rotateTg;
    private InputHandler<?> orih;
    private final List<TransformGroup> face_to_camera_transforms = new LinkedList<TransformGroup>();
    private final Matrix3f rotMat = new Matrix3f();
    private final HashMap<String, TransformGroup> shapeTgs = new HashMap();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
        this.orih.setMouseMovementSuspended(!state);
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        float f = (float)wheelDelta * 0.3f;
        this.camera.add(0.0f, 0.0f, f);
        this.env.getView().setPosition(this.camera);
    }

    private void addText(TransformGroup ltg, String txt, Tuple3f pos, boolean face_to_camera) {
        Transform3D trans = new Transform3D(pos);
        trans.setScale(0.003f);
        TransformGroup ttg = new TransformGroup(trans);
        Text2D t2D = new Text2D(txt);
        t2D.setResolution(64);
        ttg.addChild(t2D);
        ltg.addChild(ttg);
        if (face_to_camera) {
            this.face_to_camera_transforms.add(ttg);
        }
    }

    private TransformGroup createXYZcoordinateSystem(float ll, String add_txt, boolean face_to_camera) {
        Tuple3f zero = new Tuple3f(0.0f, 0.0f, 0.0f);
        Tuple3f lx = new Tuple3f(ll, 0.0f, 0.0f);
        Tuple3f ly = new Tuple3f(0.0f, ll, 0.0f);
        Tuple3f lz = new Tuple3f(0.0f, 0.0f, ll);
        TransformGroup tg_xyz = new TransformGroup();
        tg_xyz.setName("XYZ_Coortdinate " + add_txt);
        tg_xyz.addChild(new Line(zero, lx, Colorf.RED));
        tg_xyz.addChild(new Line(zero, ly, Colorf.GREEN));
        tg_xyz.addChild(new Line(zero, lz, Colorf.BLUE));
        float fl = ll;
        Tuple3f p1x = new Tuple3f(0.0f, 0.0f, fl);
        Tuple3f pmx = new Tuple3f(0.0f, 0.0f, 0.0f);
        Tuple3f p2x = new Tuple3f(0.0f, fl, 0.0f);
        Tuple3f p1y = new Tuple3f(fl, 0.0f, 0.0f);
        Tuple3f pmy = new Tuple3f(0.0f, 0.0f, 0.0f);
        Tuple3f p2y = new Tuple3f(0.0f, 0.0f, fl);
        Tuple3f p1z = new Tuple3f(0.0f, fl, 0.0f);
        Tuple3f pmz = new Tuple3f(0.0f, 0.0f, 0.0f);
        Tuple3f p2z = new Tuple3f(fl, 0.0f, 0.0f);
        for (float a = 0.0f; a < ll; a += 1.0f) {
            p1x.addX(1.0f);
            pmx.addX(1.0f);
            p2x.addX(1.0f);
            tg_xyz.addChild(new Line(p1x, pmx, Colorf.GRAY));
            tg_xyz.addChild(new Line(p2x, pmx, Colorf.GRAY));
            p1y.addY(1.0f);
            pmy.addY(1.0f);
            p2y.addY(1.0f);
            tg_xyz.addChild(new Line(p1y, pmy, Colorf.GRAY));
            tg_xyz.addChild(new Line(p2y, pmy, Colorf.GRAY));
            p1z.addZ(1.0f);
            pmz.addZ(1.0f);
            p2z.addZ(1.0f);
            tg_xyz.addChild(new Line(p1z, pmz, Colorf.GRAY));
            tg_xyz.addChild(new Line(p2z, pmz, Colorf.GRAY));
        }
        this.addText(tg_xyz, add_txt + "X", lx, face_to_camera);
        this.addText(tg_xyz, add_txt + "Y", ly, face_to_camera);
        this.addText(tg_xyz, add_txt + "Z", lz, face_to_camera);
        return tg_xyz;
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.rotateTg.getTransform().getRotation(this.rotMat);
        this.rotMat.invert();
        for (TransformGroup trgr : this.face_to_camera_transforms) {
            Transform3D tr3d = trgr.getTransform();
            tr3d.setRotation(this.rotMat);
            trgr.setTransform(tr3d);
        }
    }

    private void addOneShape(String name, Shape3D shape, float x, float y, float z) {
        TransformGroup ltg = new TransformGroup(new Transform3D(x, y, z));
        ltg.setName(name);
        shape.getAppearance().setDrawMode(DrawMode.LINE);
        shape.setName(name + "_shape");
        ltg.addChild(shape);
        this.shapeTgs.put(name, ltg);
    }

    private void loadShapes() {
        Shape3D shape = new Cube(1.1f, Colorf.RED);
        this.addOneShape("cube", shape, 0.5f, 7.0f, 0.0f);
        shape = new Torus(0.3f, 0.5f, 10, 10, Colorf.YELLOW);
        this.addOneShape("torus", shape, 0.0f, 2.0f, 0.0f);
    }

    private void setupPhysics(Xith3DEnvironment env) {
        JoodePhysicsEngine physEng = new JoodePhysicsEngine();
        CollisionEngine collEng = physEng.getCollisionEngine();
        SimulationEngine simEng = physEng.getSimulationEngine();
        SimulationWorld simWorld = simEng.newWorld();
        PhysicsGFXManager gfxManager = physEng.getGFXManager();
        CollideableGroup collGroup = collEng.newGroup("OcTree");
        simWorld.setGravity(0.0f, -0.05f, 0.0f);
        physEng.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(0.0f));
        for (TransformGroup ltg : this.shapeTgs.values()) {
            System.out.println("Adding TransferGroup '" + ltg.getName() + "' with shape '" + ltg.getChild(0).getName() + "'");
            Body body = simWorld.newBody();
            if ("torus".equals(ltg.getName())) {
                body.setGravityEnabled(false);
                body.setLinearVelocity(0.0f, 0.4f, 0.0f);
            }
            body.setPosition(ltg.getPosition());
            Shape3D shape = (Shape3D)ltg.findFirst(ltg.getName() + "_shape");
            TriMeshCollideable col = collEng.newTriMesh(shape);
            body.addCollideable(col);
            collGroup.addCollideable(col);
            this.rotateTg.addChild(ltg);
            gfxManager.directAdd(body, ltg, null);
            simWorld.addBody(body);
        }
        CollisionResolver collRes = new CollisionResolver(collGroup);
        physEng.addCollisionResolver(collRes);
        env.setPhysicsEngine(physEng);
    }

    private BranchGroup createScene() {
        this.loadShapes();
        Transform3D t3d = new Transform3D();
        t3d.rotY(FastMath.toRad(-15.0f));
        this.rotateTg = new TransformGroup(t3d);
        this.rotateTg.addChild(this.createXYZcoordinateSystem(5.0f, "tg", true));
        this.setupPhysics(this.env);
        BranchGroup bg = new BranchGroup((Node)this.rotateTg);
        return bg;
    }

    public SimpleSimulationTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        System.out.println();
        System.out.println("   -- Rotate with mouse buttons --");
        System.out.println("     -- Zoom with mouse wheel --");
        System.out.println("          -- ESC to end --");
        System.out.println();
        this.camera = new Point3f(0.0f, 6.0f, 4.0f);
        this.env = new Xith3DEnvironment(this.camera, new Point3f(0.0f, 5.0f, 0.0f), new Vector3f(0.0f, 2.0f, 0.0f), this);
        BranchGroup scene = this.createScene();
        this.env.addPerspectiveBranch(scene);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        this.orih = new ObjectRotationInputHandler(this.rotateTg, 1.0f, arguments.getMouseYInverted() ? -1.0f : 1.0f, this.env.getView());
        this.orih.setMouseMovementSuspended(true);
        InputSystem.getInstance().addInputHandler(this.orih);
    }

    public static void main(String[] args) throws Throwable {
        SimpleSimulationTest test = new SimpleSimulationTest(SimpleSimulationTest.parseCommandLine(args));
        test.begin();
    }
}

