/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.physics;

import java.util.HashMap;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.ObjectRotationInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsEngine;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.collideable.TriMeshCollideable;
import org.xith3d.physics.joode.JoodePhysicsEngine;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.joints.HingeJoint;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.physics.visual_joints.utils.CoordinateSystem;
import org.xith3d.test.physics.visual_joints.utils.DirectedText;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates a simple physics", "simulation with different joints between the bodys. (Not yet ready, working...)"}, authors={"Thomas Welsch (aka ttww)"})
public class SimpleSimulationTest2
extends Xith3DTest {
    private Xith3DEnvironment env;
    private PhysicsEngine physEng;
    private CollisionEngine collEng;
    private SimulationEngine simEng;
    private SimulationWorld simWorld;
    private PhysicsGFXManager gfxManager;
    private CollideableGroup collGroup;
    private Point3f camera;
    private Canvas3D canvas;
    private TransformGroup rotateTg;
    private InputHandler<?> orih;
    private DirectedText directedText;
    private boolean pause = false;
    private final HashMap<String, TestShape> shapeTs = new HashMap();

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.pause = !this.pause;
                this.simEng.setEnabled(!this.pause);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
        this.orih.setMouseMovementSuspended(!state);
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        float f = (float)wheelDelta * 0.3f;
        this.camera.add(0.0f, 0.0f, f);
        this.env.getView().setPosition(this.camera);
    }

    private void updateVisualHinges() {
        for (TestShape ts : this.shapeTs.values()) {
            Colorf col;
            if (ts.joint == null) continue;
            float xs = ts.joint.getBody1().getPositionX();
            float ys = ts.joint.getBody1().getPositionY();
            float zs = ts.joint.getBody1().getPositionZ();
            float xe = ts.joint.getAnchor().getX();
            float ye = ts.joint.getAnchor().getY();
            float ze = ts.joint.getAnchor().getZ();
            if (ts.line_a_to_anchor == null) {
                col = new Colorf(Colorf.RED, 0.5f);
                ts.line_a_to_anchor = new Line((Tuple3f)new Point3f(xs, ys, zs), (Tuple3f)new Point3f(xe, ye, ze), 8.0f, col);
                this.rotateTg.addChild(ts.line_a_to_anchor);
            } else {
                ts.line_a_to_anchor.setCoordinates(xs, ys, zs, xe, ye, ze);
            }
            if (ts.joint.getBody2() == null) continue;
            xs = ts.joint.getBody2().getPositionX();
            ys = ts.joint.getBody2().getPositionY();
            zs = ts.joint.getBody2().getPositionZ();
            if (ts.line_anchor_to_b == null) {
                col = new Colorf(Colorf.GREEN, 0.5f);
                ts.line_anchor_to_b = new Line((Tuple3f)new Point3f(xe, ye, ze), (Tuple3f)new Point3f(xs, ys, zs), 8.0f, col);
                this.rotateTg.addChild(ts.line_anchor_to_b);
                continue;
            }
            ts.line_anchor_to_b.setCoordinates(xe, ye, ze, xs, ys, zs);
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        TestShape ts = this.shapeTs.get("joint_cube_A1");
        if (ts != null && ts.body != null) {
            ts.body.addForce(0.0f, 200.0f, 0.0f);
        }
        if ((ts = this.shapeTs.get("joint_cube_A2")) != null && ts.body != null) {
            ts.body.addForce(0.0f, 100.0f, 0.0f);
        }
        this.directedText.updateTextDirections();
        this.updateVisualHinges();
    }

    private TestShape addOneShape(String name, Shape3D shape, float x, float y, float z) {
        TestShape ts = new TestShape();
        ts.shape = shape;
        shape.getAppearance().setDrawMode(DrawMode.LINE);
        shape.setName(name + "_shape");
        ts.ltg = new TransformGroup();
        ts.ltg.setName(name);
        ts.ltg.addChild(shape);
        this.shapeTs.put(name, ts);
        ts.body = this.simWorld.newBody();
        ts.body.setName(name);
        ts.body.setPosition(x, y, z);
        TriMeshCollideable col = this.collEng.newTriMesh(shape);
        col.setName(name);
        ts.body.addCollideable(col);
        this.collGroup.addCollideable(col);
        return ts;
    }

    private void loadShapes() {
        Cube shape = new Cube(0.8f, Colorf.CYAN);
        TestShape ts = this.addOneShape("joint_cube_A1", shape, 0.5f, 7.0f, 4.0f);
        ts.body.setGravityEnabled(true);
        ts.body.setMass(10000.0f);
        shape = new Cube(0.8f, Colorf.GREEN);
        TestShape ts2 = this.addOneShape("joint_cube_B1", shape, 2.5f, 7.0f, 4.0f);
        ts2.joint = this.simWorld.newHingeJoint(ts2.body, ts.body);
        ts2.joint.setAxis(Vector3f.NEGATIVE_Z_AXIS);
        ts2.joint.setAnchor(ts.body.getPositionX(), ts.body.getPositionY() - 0.5f, ts.body.getPositionZ());
        shape = new Cube(0.8f, Colorf.BLUE);
        ts = this.addOneShape("joint_cube_A2", shape, 0.5f, 7.0f, 3.0f);
        ts.body.setGravityEnabled(true);
        ts.body.setMass(10000.0f);
        shape = new Cube(0.8f, Colorf.GREEN);
        ts2 = this.addOneShape("joint_cube_B2", shape, 1.5f, 7.0f, 3.0f);
        ts2.joint = this.simWorld.newHingeJoint(ts2.body, ts.body);
        ts2.joint.setAxis(Vector3f.NEGATIVE_Z_AXIS);
        ts2.joint.setAnchor(ts.body.getPositionX(), ts.body.getPositionY() - 0.5f, ts.body.getPositionZ());
    }

    private void initPhysicsEnvironment() {
        this.physEng = new JoodePhysicsEngine();
        this.collEng = this.physEng.getCollisionEngine();
        this.simEng = this.physEng.getSimulationEngine();
        this.simWorld = this.simEng.newWorld();
        this.gfxManager = this.physEng.getGFXManager();
        this.collGroup = this.collEng.newGroup("OcTree");
    }

    private void setupPhysics(Xith3DEnvironment env) {
        this.simWorld.setGravity(0.0f, -0.01f, 0.0f);
        this.physEng.getDefaultSurfaceParameters().setParameter("bounce", Float.valueOf(0.0f));
        for (TestShape ts : this.shapeTs.values()) {
            System.out.println("Adding TestShape \"" + ts.ltg.getName() + "\"");
            this.gfxManager.directAdd(ts.body, ts.ltg, (GroupNode)this.rotateTg);
            this.simWorld.addBody(ts.body);
            if (ts.joint == null) continue;
            this.simWorld.addJoint(ts.joint);
        }
        CollisionResolver collRes = new CollisionResolver(this.collGroup);
        this.physEng.addCollisionResolver(collRes);
        env.setPhysicsEngine(this.physEng);
    }

    private BranchGroup createScene() {
        this.initPhysicsEnvironment();
        this.loadShapes();
        Transform3D t3d = new Transform3D();
        t3d.rotY(FastMath.toRad(-15.0f));
        this.rotateTg = new TransformGroup(t3d);
        this.directedText = new DirectedText(this.rotateTg);
        this.rotateTg.addChild(CoordinateSystem.createXYZcoordinateSystem(this.directedText, 5.0f, "tg", true));
        this.updateVisualHinges();
        this.setupPhysics(this.env);
        BranchGroup bg = new BranchGroup((Node)this.rotateTg);
        return bg;
    }

    public SimpleSimulationTest2(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        System.out.println();
        System.out.println("   -- Rotate with mouse buttons --");
        System.out.println("     -- Zoom with mouse wheel --");
        System.out.println("      -- Space toggles pause --");
        System.out.println("          -- ESC to end --");
        System.out.println();
        this.camera = new Point3f(0.0f, 8.0f, 10.0f);
        this.env = new Xith3DEnvironment(this.camera, new Point3f(0.0f, 5.0f, 0.0f), new Vector3f(0.0f, 2.0f, 0.0f), this);
        BranchGroup scene = this.createScene();
        this.env.addPerspectiveBranch(scene);
        this.canvas = Canvas3DFactory.create(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.orih = new ObjectRotationInputHandler(this.rotateTg, 1.0f, arguments.getMouseYInverted() ? -1.0f : 1.0f, this.env.getView());
        this.orih.setMouseMovementSuspended(true);
        InputSystem.getInstance().addInputHandler(this.orih);
    }

    public static void main(String[] args) throws Throwable {
        SimpleSimulationTest2 test = new SimpleSimulationTest2(SimpleSimulationTest2.parseCommandLine(args));
        test.begin();
    }

    private class TestShape {
        Shape3D shape;
        Body body;
        TransformGroup ltg;
        HingeJoint joint;
        Line line_a_to_anchor;
        Line line_anchor_to_b;

        private TestShape() {
        }
    }
}

