/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.picking;

import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point2f;
import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector4f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.picking.PickingLibrary;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.picking.PickingTestUtils;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"Simple Xith3D PickingLibrary test"}, authors={"Yuri Vl. Gushchin (aka YVG)", "Marvin Froehlich (aka Qudus)", "Amos Wenger (aka BlueSky)"})
public class PickingLibraryTest
extends Xith3DTest
implements PickListener {
    private Canvas3D canvas;
    private BranchGroup rootBranch;
    private RenderPass renderPass;
    private HUD hud;
    private Image img;

    @Override
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    @Override
    public void onMouseButtonReleased(MouseButtonReleasedEvent e, MouseButton button) {
        System.out.println("Picking at " + e.getX() + ", " + e.getY());
        if (button == MouseButtons.LEFT_BUTTON) {
            PickingLibrary.pickNearest(this.rootBranch, this.canvas, button, e.getX(), e.getY(), (NearestPickListener)this);
        } else if (button == MouseButtons.RIGHT_BUTTON) {
            PickingLibrary.pickAll(this.rootBranch, this.canvas, button, e.getX(), e.getY(), (AllPickListener)this);
        }
    }

    public Point2f worldToScreen(Tuple3f p) {
        Matrix4f mP = this.canvas.getView().calculatePerspective(this.canvas).getMatrix4f();
        Matrix4f mM = this.canvas.getView().getModelViewTransform(true).getMatrix4f();
        Vector4f v0 = new Vector4f(p.getX(), p.getY(), p.getZ(), 1.0f);
        Vector4f v = new Vector4f();
        v.mul(mM, v0);
        v0.set((TupleNf)v);
        v.mul(mP, v0);
        v.setW(1.0f / v.getW() * 0.5f);
        v.setX(v.getX() * v.getW() + 0.5f);
        v.setY(v.getY() * v.getW() + 0.5f);
        v.setZ(v.getZ() * v.getW() + 0.5f);
        float xs = (float)this.canvas.getWidth() * v.getX();
        float ys = (float)this.canvas.getHeight() - (float)this.canvas.getHeight() * v.getY();
        return new Point2f(xs, ys);
    }

    @Override
    public boolean testIntersectionsInWorldSpaceForPicking() {
        return false;
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        System.out.println("  Hit Shape3D: \"" + nearest.getNode().getName() + "\", distance=" + nearest.getMinimumDistance() + " position=" + nearest.getPos());
        Point2i p = new Point2i();
        this.canvas.worldToScreen(nearest.getPos(), p);
        this.img.setLocation((float)p.getX() - this.img.getWidth() / 2.0f, (float)p.getY() - this.img.getHeight() / 2.0f);
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        System.out.println("Detected " + pickResults.size() + " hits");
        int i = 0;
        for (PickResult pr : pickResults) {
            System.out.println("  Hit (" + i++ + "): Shape3D: \"" + pr.getNode().getName() + "\", distance=" + pr.getMedialDistance() + " position=" + pr.getPos());
        }
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        System.out.println("You just picked nothing!");
    }

    private void createHUD(Xith3DEnvironment env) {
        this.hud = new HUD(this.canvas);
        Texture2D tex = TextureLoader.getInstance().getTexture("CrosshairWhite.png", Texture.MipmapMode.BASE_LEVEL);
        this.img = new Image((float)tex.getOriginalWidth(), (float)tex.getOriginalHeight(), tex);
        this.hud.getContentPane().addWidgetCentered(this.img);
        env.addHUD(this.hud);
    }

    public PickingLibraryTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("HUD");
        this.rootBranch = PickingTestUtils.createSceneGraph(this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(this.rootBranch);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        this.createHUD(env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler((Transformable)env.getView(), env.getCanvas(), 0.5f, 0.5f, arguments.getMouseYInverted(), 0.5f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        System.out.println("Hit ESC to exit, SPACE to toggle projection policy, click mouse on object to perform pick");
        System.out.println("Note that due to Linux workarounds planes with CULL_NONE are pickable only from one (face) side...");
    }

    public static void main(String[] args) throws Throwable {
        PickingLibraryTest test = new PickingLibraryTest(PickingLibraryTest.parseCommandLine(args));
        test.begin();
    }
}

