/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.types.twodee.util.ResizeListener2i;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderCallbackAdapter;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Anaglph Demo of a simple scene", "started life as the QuadViewportTest."}, authors={"Marvin Froehlich (aka Qudus)", "Andy Bailey (aka hazlorealidad)"})
public class AnaglyphDemo1
extends Xith3DTest {
    private static final boolean debug = false;
    private View view;
    private static final boolean wireframe = false;
    private Rect2i viewport;
    private RenderPass leftPass;
    private RenderPass rightPass;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Rect2i initViewport(SceneGraph sg, Sized2iRO res, BranchGroup branchGroup) {
        int width = res.getWidth();
        int height = res.getHeight();
        Rect2i viewport = new Rect2i(0, 0, width, height);
        this.leftPass = RenderPass.createPerspective(branchGroup);
        this.leftPass.getConfig().setViewport(viewport);
        this.leftPass.addRenderCallback(new Side(true));
        this.rightPass = RenderPass.createPerspective(branchGroup);
        this.rightPass.getConfig().setViewport(viewport);
        this.rightPass.addRenderCallback(new Side(false));
        Transform3D viewTransLeft = new Transform3D();
        this.leftPass.getConfig().setViewTransform(viewTransLeft);
        Transform3D viewTransRight = new Transform3D();
        this.rightPass.getConfig().setViewTransform(viewTransRight);
        sg.addRenderPass(this.leftPass);
        sg.addRenderPass(this.rightPass);
        return viewport;
    }

    private void initGUI(SceneGraph sg, Sized2iRO res) {
        HUD hud = new HUD(res.getWidth(), res.getHeight());
        sg.addHUD(hud);
    }

    private BranchGroup createSceneGraph() {
        Cube testCube = new Cube(3.0f, "jplogo.jpg");
        BranchGroup branchGroup = new BranchGroup(testCube);
        return branchGroup;
    }

    public AnaglyphDemo1(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        View view = new View(4.0f, 4.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup branchGroup = this.createSceneGraph();
        this.viewport = this.initViewport(env, arguments.getResolution(), branchGroup);
        this.initGUI(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        StereoFirstPersonInputHandler fpHandler = new StereoFirstPersonInputHandler(view, canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpHandler);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        canvas.addResizeListener(new Resize());
        this.addFPSListener(new CanvasFPSListener(canvas));
    }

    public static void main(String[] args) throws Throwable {
        AnaglyphDemo1 test = new AnaglyphDemo1(AnaglyphDemo1.parseCommandLine(args));
        test.begin();
    }

    public class StereoFirstPersonInputHandler
    extends FirstPersonInputHandler {
        public void update(long nanoSeconds, float seconds, long nanoFrame, float frameSeconds) throws InputSystemException {
            super.update(nanoSeconds, seconds, nanoFrame, frameSeconds);
            AnaglyphDemo1.this.view = this.getView();
        }

        public StereoFirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, boolean yInverted) {
            super(view, resolutionX, resolutionY, 1.0f, 1.0f, yInverted, 1.0f);
        }

        public StereoFirstPersonInputHandler(View view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, boolean yInverted, float movementSpeed) {
            super((Transformable)view, resolution, mouseXSpeed, mouseYSpeed, yInverted, movementSpeed);
        }
    }

    public class Resize
    implements ResizeListener2i {
        public void onObjectResized(Sized2i object, int oldWidth, int oldHeight, int newWidth, int newHeight) {
            System.out.println("Resized " + newWidth + "x" + newHeight);
            AnaglyphDemo1.this.viewport.set(0, 0, newWidth, newHeight);
        }
    }

    public class Side
    extends RenderCallbackAdapter {
        private final boolean left;
        private final Vector3f tmpVec1 = new Vector3f();
        private final Vector3f tmpVec2 = new Vector3f();

        public void setup(RenderPass renderPass) {
            Transform3D trans = AnaglyphDemo1.this.view.getTransform();
            RenderPassConfig config = renderPass.getConfig();
            config.getViewTransform().set(trans);
            trans.getTranslation(this.tmpVec1);
            this.tmpVec2.set(0.5f, 0.0f, 0.0f);
            trans.transform(this.tmpVec2);
            this.tmpVec2.add(this.tmpVec1);
            if (this.left) {
                config.getViewTransform().setTranslation(this.tmpVec2);
            }
            this.tmpVec2.set(-0.5f, 0.0f, 0.0f);
            trans.transform(this.tmpVec2);
            this.tmpVec2.add(this.tmpVec1);
            if (!this.left) {
                config.getViewTransform().setTranslation(this.tmpVec2);
            }
            config.setColorMask(this.left, !this.left, !this.left, true);
        }

        public void beforeRenderPassIsProcessed(RenderPass renderPass) {
            this.setup(renderPass);
        }

        public Side(boolean left) {
            this.left = left;
        }
    }
}

