/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.awt.Font;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.TextBillboard;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

@Xith3DTest.Description(fulltext={"Demonstrates, how Billboards work."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BillboardTest
extends Xith3DTest {
    private AngleInterpolater angleInterpol;
    private Tuple3f eyePos = new Point3f(5.0f, 0.0f, 10.0f);
    private Tuple3f focus = new Point3f(0.0f, 0.0f, 0.0f);
    private Tuple3f vecUp = new Point3f(0.0f, 1.0f, 0.0f);
    private View view;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void onRenderLoopStarted() {
        super.onRenderLoopStarted();
        this.angleInterpol = new AngleInterpolater(0.0f, 1.5707964f, 0.0f, (float)Math.PI * 2, true);
        this.angleInterpol.startIncreasing(this.getGameMicroTime());
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        float angle = this.angleInterpol.getValue(timingMode.getMicroSeconds(gameTime));
        this.eyePos.set(5.0f * FastMath.cos(angle), 5.0f * FastMath.sin(angle), this.eyePos.getZ());
        this.view.lookAt(this.eyePos, this.focus, this.vecUp);
    }

    private BranchGroup createScene() {
        BranchGroup root = new BranchGroup();
        Cube cube1 = new Cube(3.0f, "stone.jpg");
        Cube cube2 = new Cube(3.0f, "grass.jpg");
        Cube cube3 = new Cube(3.0f, "jplogo.png");
        TransformGroup tg1 = new TransformGroup(new Transform3D(-5.0f, 0.0f, 0.0f));
        TransformGroup tg2 = new TransformGroup(new Transform3D(0.0f, 0.0f, 0.0f));
        TransformGroup tg3 = new TransformGroup(new Transform3D(5.0f, 0.0f, 0.0f));
        tg1.addChild(cube1);
        tg2.addChild(cube2);
        tg3.addChild(cube3);
        root.addChild(tg1);
        root.addChild(tg2);
        root.addChild(tg3);
        TransformGroup tg4 = new TransformGroup(new Transform3D(0.0f, 0.0f, 5.0f));
        TextBillboard textRect = TextBillboard.createFixedWidth(10.0f, "Hi! This is a Text on a Billboard.\nSo the Text will always\nface the Camera.", new Colorf(0.55f, 1.0f, 0.8f), new Font("Verdana", 0, 12), 1);
        tg4.addChild(textRect);
        textRect = TextBillboard.createFixedWidth(5.0f, "I am in front of\nthe other text and\ntransparency is just\n FINE !!", new Colorf(0.7f, 0.55f, 1.0f), new Font("Verdana", 0, 12), 1);
        tg4.addChild(new Transform(textRect).setTranslation(1.0f, 1.0f, 1.0f));
        root.addChild(tg4);
        return root;
    }

    public BillboardTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this.eyePos, this.focus, this.vecUp, this);
        this.view = env.getView();
        env.getRenderer().setTransparentSortingPolicy(Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BillboardTest test = new BillboardTest(BillboardTest.parseCommandLine(args));
        test.begin();
    }
}

