/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Test for Xith3D's bumpmapping capabilities"}, authors={"Marvin Froehlich (aka Qudus)"})
public class BumpMappingTest2
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    private BranchGroup createScene(Animator animator) {
        BranchGroup scene = new BranchGroup();
        Rectangle rect = new Rectangle(9.0f, 6.75f, "tilebase.jpg");
        rect.setTexturePosition(new Tuple2f(2.0f, 2.0f * rect.getHeight() / rect.getWidth()));
        rect.setBumpMappingEnabled(true, "tiledot3.jpg");
        TransformGroup tg = new TransformGroup();
        scene.addChild(tg);
        tg.addChild(rect);
        Vector3f lightTranslation = new Vector3f(1.0f, 0.0f, 3.0f);
        PointLight light = new PointLight();
        light.setAttenuation(1.0f, 0.0f, 0.0f);
        scene.addChild(light);
        Sphere lightAvatar = new Sphere(0.2f, 8, 8, Colorf.YELLOW);
        TransformGroup tgLightTrans = new TransformGroup(new Transform3D(lightTranslation));
        tgLightTrans.addChild(lightAvatar);
        RotatableGroup lightRotator = new RotatableGroup(new TransformationDirectives(0.0f, 0.0f, 0.25f));
        lightRotator.addChild(tgLightTrans);
        scene.addChild(lightRotator);
        animator.addAnimatableObject(lightRotator);
        light.setTrackedNode(lightAvatar);
        lightAvatar.setVisible(true);
        return scene;
    }

    public BumpMappingTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL();
        resLoc.createAndAddTSL("phong");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(this.getAnimator()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BumpMappingTest2 test = new BumpMappingTest2(BumpMappingTest2.parseCommandLine(args));
        test.begin();
    }
}

