/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.awt.Color;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.types.twodee.util.ResizeListener2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderCallbackAdapter;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.traversal.TraversalCallback;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"ChromaDepth Demo of a simple scene", "started life as the QuadViewportTest."}, authors={"Marvin Froehlich (aka Qudus)", "Andy Bailey (aka hazlorealidad)"})
public class ChromaDepthTest
extends Xith3DTest {
    private static boolean debug = false;
    private boolean wireframe = false;
    private Rect2i viewport;
    private RenderPass renderPass;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Rect2i initViewport(SceneGraph sg, Sized2iRO res, BranchGroup branchGroup) {
        int width = res.getWidth();
        int height = res.getHeight();
        Rect2i viewport = new Rect2i(0, 0, width, height);
        this.renderPass = RenderPass.createPerspective(branchGroup);
        this.renderPass.getConfig().setViewport(viewport);
        this.renderPass.addRenderCallback(new ChromaDepthCallback());
        if (this.wireframe) {
            this.renderPass.getConfig().setRenderOptions(new RenderOptions());
            this.renderPass.getConfig().getRenderOptions().setWireframeModeEnabled(true);
        }
        sg.addRenderPass(this.renderPass);
        return viewport;
    }

    private void initGUI(SceneGraph sg, Sized2iRO res) {
        HUD hud = new HUD(res.getWidth(), res.getHeight());
        sg.addHUD(hud);
    }

    private BranchGroup createSceneGraph() {
        BranchGroup branchGroup = new BranchGroup();
        for (int i = -10; i < 10; i += 5) {
            Vector3f translation = new Vector3f(i, 0.0f, 0.0f);
            Cube testCube = new Cube(3.0f);
            Transform3D transform = new Transform3D();
            transform.setTranslation(translation);
            TransformGroup transformGroup = new TransformGroup();
            transformGroup.setTransform(transform);
            transformGroup.addChild(testCube);
            branchGroup.addChild(transformGroup);
        }
        return branchGroup;
    }

    public ChromaDepthTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(10.0f, 3.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup branchGroup = this.createSceneGraph();
        this.viewport = this.initViewport(env, arguments.getResolution(), branchGroup);
        this.initGUI(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        canvas.addResizeListener(new Resize());
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpHandler = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        ChromaDepthTest test = new ChromaDepthTest(ChromaDepthTest.parseCommandLine(args));
        test.begin();
    }

    public class Resize
    implements ResizeListener2i {
        public void onObjectResized(Sized2i object, int oldWidth, int oldHeight, int newWidth, int newHeight) {
            System.out.println("Resized " + newWidth + "x" + newHeight);
            ChromaDepthTest.this.viewport.set(0, 0, newWidth, newHeight);
        }
    }

    public class ChromaDepthCallback
    extends RenderCallbackAdapter {
        public void setup(RenderPass renderPass) {
            BranchGroup branchGroup = renderPass.getBranchGroup();
            ChromaDepthTraversal traversal = new ChromaDepthTraversal(branchGroup.getSceneGraph().getView());
            branchGroup.traverse(traversal);
        }

        public void beforeRenderPassIsProcessed(RenderPass renderPass) {
            this.setup(renderPass);
        }

        public void beforeRenderPassIsRendered(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
        }

        public void afterRenderPassIsSetUp(RenderPass renderPass, OpenGLLayer openGLLayer, Object glObj) {
        }
    }

    private static class ChromaDepthTraversal
    implements TraversalCallback {
        private final float scale = 0.05f;
        private final View view;

        public boolean traversalCheckGroup(GroupNode group) {
            return true;
        }

        public boolean traversalOperation(Node node2) {
            if (node2 instanceof Shape3D) {
                Shape3D shape = (Shape3D)node2;
                Geometry geometry = shape.getGeometry();
                Point3f vertexCoord = new Point3f();
                Point3f viewPos = new Point3f();
                int numVertex = geometry.getVertexCount();
                if (debug) {
                    int colorSize = geometry.getColorsSize();
                    if (geometry.hasColors()) {
                        System.out.println("Color size " + colorSize + " Has colors " + (geometry.hasColorAlpha() ? "with alpha" : "without alpha"));
                    } else {
                        System.out.println("No colors yet - Color size " + colorSize);
                    }
                }
                Transform3D trans = shape.getWorldTransform();
                Colorf[] colors = new Colorf[numVertex];
                this.view.getPosition(viewPos);
                for (int i = 0; i < numVertex; ++i) {
                    float distToView;
                    geometry.getVertex(i, vertexCoord);
                    trans.transform(vertexCoord);
                    float z = distToView = viewPos.distance(vertexCoord);
                    float hue = (z - 5.0f) * 0.05f;
                    if (hue > 0.7f) {
                        hue = 0.7f;
                    }
                    if (hue < 0.0f) {
                        hue = 0.0f;
                    }
                    float saturation = 1.0f;
                    float brightness = 1.0f;
                    int hsb = Color.HSBtoRGB(hue, saturation, brightness);
                    float red = (float)(hsb >> 16 & 0xFF) / 256.0f;
                    float green = (float)(hsb >> 8 & 0xFF) / 256.0f;
                    float blue = (float)(hsb & 0xFF) / 256.0f;
                    float alpha = 1.0f;
                    colors[i] = new Colorf(red, green, blue, alpha);
                    if (!debug) continue;
                    System.out.println("Vertex " + i + " dist " + z + " hue " + hue + " color " + colors[i]);
                }
                geometry.setColors(0, colors);
            }
            return true;
        }

        public ChromaDepthTraversal(View view) {
            this.view = view;
        }
    }
}

