/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageFormat;
import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.QuadArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D CombineInterpolate test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class CombineInterpolateTest
extends Xith3DTest {
    private View view;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.view.getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.view.setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.view.setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    private static Texture2D getTexture() {
        BufferedImage theImage = new BufferedImage(64, 64, 2);
        Graphics2D theGraphics = theImage.createGraphics();
        FontMetrics theMetrics = theGraphics.getFontMetrics();
        theGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        theGraphics.setColor(Color.white);
        theGraphics.drawString("Xith3D", 0, theMetrics.getAscent());
        TextureImage2D theImageComponent = new TextureImage2D(TextureImageFormat.LUMINANCE, theImage, false);
        Texture2D theTexture = new Texture2D(TextureFormat.getFormat(theImageComponent.getFormat()));
        theTexture.setImage(0, theImageComponent);
        return theTexture;
    }

    private static Node createShape() {
        QuadArray theQuadArray = new QuadArray(4);
        theQuadArray.setCoordinate(0, -0.5f, -0.5f, 0.0f);
        theQuadArray.setCoordinate(1, -0.5f, 0.5f, 0.0f);
        theQuadArray.setCoordinate(2, 0.5f, 0.5f, 0.0f);
        theQuadArray.setCoordinate(3, 0.5f, -0.5f, 0.0f);
        theQuadArray.setTextureCoordinate(0, 0, 0.0f, 1.0f);
        theQuadArray.setTextureCoordinate(0, 1, 0.0f, 0.0f);
        theQuadArray.setTextureCoordinate(0, 2, 1.0f, 0.0f);
        theQuadArray.setTextureCoordinate(0, 3, 1.0f, 1.0f);
        Appearance theAppearance = new Appearance();
        theAppearance.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(Colorf.YELLOW);
        theAppearance.setColoringAttributes(ca);
        TextureAttributes theTextureAttributes = new TextureAttributes();
        theTextureAttributes.setTextureMode(TextureMode.COMBINE);
        theTextureAttributes.setCombineRGBMode(TextureAttributes.COMBINE_INTERPOLATE);
        theTextureAttributes.setCombineRGBSource(0, TextureAttributes.COMBINE_CONSTANT_COLOR);
        theTextureAttributes.setCombineRGBSource(1, TextureAttributes.COMBINE_OBJECT_COLOR);
        theTextureAttributes.setCombineRGBSource(2, TextureAttributes.COMBINE_TEXTURE_COLOR);
        theTextureAttributes.setCombineRGBFunction(0, TextureAttributes.COMBINE_SRC_COLOR);
        theTextureAttributes.setCombineRGBFunction(1, TextureAttributes.COMBINE_SRC_COLOR);
        theTextureAttributes.setCombineRGBFunction(2, TextureAttributes.COMBINE_SRC_COLOR);
        theTextureAttributes.setTextureBlendColor(new Colorf(1.0f, 0.0f, 0.0f, 1.0f));
        theAppearance.setTextureAttributes(theTextureAttributes);
        theAppearance.setTexture(CombineInterpolateTest.getTexture());
        Shape3D theShape = new Shape3D(theQuadArray, theAppearance);
        return theShape;
    }

    protected BranchGroup createSceneGraph() throws Exception {
        BranchGroup objRoot = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Node shape = CombineInterpolateTest.createShape();
        sceneRootTransform.addChild(shape);
        this.getAnimator().addAnimatableObject(testRotateYGroup);
        return objRoot;
    }

    public CombineInterpolateTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.view = env.getView();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createSceneGraph());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        CombineInterpolateTest test = new CombineInterpolateTest(CombineInterpolateTest.parseCommandLine(args));
        test.begin();
    }
}

