/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.LineArray;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Line Attributes test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class LineAttributesTest
extends Xith3DTest {
    private RenderPass renderPass;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    private void createSceneGraph(BranchGroup rootBranch, Animator animator) {
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        float[] verts1 = new float[]{0.6f, 0.6f, 0.6f, -0.5f, -0.5f, -0.5f, 0.6f, 0.6f, 0.6f, 0.5f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.5f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.5f};
        LineArray geom = new LineArray(verts1.length / 3);
        geom.setCoordinates(0, verts1);
        Shape3D shape = new Shape3D(geom);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.RED, ColoringAttributes.SHADE_FLAT));
        LineAttributes lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_SOLID);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts2 = new float[]{0.0f, 0.0f, 0.0f, 0.5f, -0.5f, -0.5f};
        geom = new LineArray(verts2.length / 3);
        geom.setCoordinates(0, verts2);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.GREEN, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_DASH);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts3 = new float[]{0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f};
        geom = new LineArray(verts3.length / 3);
        geom.setCoordinates(0, verts3);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.YELLOW, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_DASH);
        lineattr.setPatternScaleFactor(2);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts4 = new float[]{0.0f, 0.0f, 0.0f, 0.5f, 0.5f, -0.5f};
        geom = new LineArray(verts4.length / 3);
        geom.setCoordinates(0, verts4);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.WHITE, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_USER_DEFINED);
        lineattr.setPatternMask(576);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts5 = new float[]{0.0f, 0.0f, 0.0f, -0.5f, 0.5f, 0.5f};
        geom = new LineArray(verts5.length / 3);
        geom.setCoordinates(0, verts5);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.BLUE, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(3.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_SOLID);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts6 = new float[]{0.0f, 0.0f, 0.0f, -0.5f, -0.5f, 0.5f};
        geom = new LineArray(verts6.length / 3);
        geom.setCoordinates(0, verts6);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.RED, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_SOLID);
        lineattr.setLineAntialiasingEnabled(true);
        appearance.setLineAttributes(lineattr);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        appearance.setTransparencyAttributes(ta);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        float[] verts7 = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f};
        geom = new LineArray(verts7.length / 3);
        geom.setCoordinates(0, verts7);
        shape = new Shape3D(geom);
        appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(Colorf.GRAY40, ColoringAttributes.SHADE_FLAT));
        lineattr = new LineAttributes();
        lineattr.setLineWidth(1.0f);
        lineattr.setLinePattern(LineAttributes.PATTERN_SOLID);
        appearance.setLineAttributes(lineattr);
        shape.setAppearance(appearance);
        scaleTransform.addChild(shape);
        rootBranch.addChild(testRotateYGroup);
        animator.addAnimatableObject(testRotateYGroup);
    }

    public LineAttributesTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = new BranchGroup();
        this.createSceneGraph(rootBranch, this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        LineAttributesTest test = new LineAttributesTest(LineAttributesTest.parseCommandLine(args));
        test.begin();
    }
}

