/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Morph;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.QuadArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.render.ColorCube;
import org.xith3d.test.render.ColorPyramidDown;
import org.xith3d.test.render.ColorPyramidUp;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Morph Pyramid2Cube test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class MorphPyramid2CubeTest
extends Xith3DTest {
    private RenderPass renderPass;
    private Morph morph;
    private double[] weights = new double[]{1.0, 0.0, 0.0};

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup rootBranch = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        scaleTransform.setTransform(t);
        testRotateYGroup.addChild(scaleTransform);
        TransformGroup[] objTrans = new TransformGroup[4];
        for (int i = 0; i < 4; ++i) {
            objTrans[i] = new TransformGroup();
            scaleTransform.addChild(objTrans[i]);
        }
        Transform3D tr = new Transform3D();
        Transform3D rotY15 = new Transform3D();
        rotY15.rotY(FastMath.toRad(15.0f));
        objTrans[0].getTransform(tr);
        tr.setTranslation(-3.0f, 1.5f, 0.0f);
        tr.mul(rotY15);
        objTrans[0].setTransform(tr);
        objTrans[1].getTransform(tr);
        tr.setTranslation(0.0f, 1.5f, 0.0f);
        tr.mul(rotY15);
        objTrans[1].setTransform(tr);
        objTrans[2].getTransform(tr);
        tr.setTranslation(3.0f, 1.5f, 0.0f);
        tr.mul(rotY15);
        objTrans[2].setTransform(tr);
        objTrans[3].getTransform(tr);
        tr.setTranslation(0.0f, -2.0f, 0.0f);
        tr.mul(rotY15);
        objTrans[3].setTransform(tr);
        Geometry[] g = new QuadArray[3];
        Shape3D[] shape = new Shape3D[3];
        for (int i = 0; i < 3; ++i) {
            g[i] = null;
            shape[i] = null;
        }
        g[0] = new ColorPyramidUp();
        g[1] = new ColorCube();
        g[2] = new ColorPyramidDown();
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        for (int i = 0; i < 3; ++i) {
            shape[i] = new Shape3D(g[i], a);
            objTrans[i].addChild(shape[i]);
        }
        this.morph = new Morph(g, a);
        objTrans[3].addChild(this.morph);
        rootBranch.addChild(testRotateYGroup);
        animator.addAnimatableObject(testRotateYGroup);
        return rootBranch;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        double a = (double)(micros % 2500000L) / 2500000.0;
        if (a < 0.25) {
            this.weights[0] = 1.0 - (a - 0.0) * 4.0;
            this.weights[1] = (a - 0.0) * 4.0;
            this.weights[2] = 0.0;
        } else if (a < 0.5) {
            this.weights[0] = 0.0;
            this.weights[1] = 1.0 - (a - 0.25) * 4.0;
            this.weights[2] = (a - 0.25) * 4.0;
        } else if (a < 0.75) {
            this.weights[0] = 0.0;
            this.weights[1] = (a - 0.5) * 4.0;
            this.weights[2] = 1.0 - (a - 0.5) * 4.0;
        } else {
            this.weights[0] = (a - 0.75) * 4.0;
            this.weights[1] = 1.0 - (a - 0.75) * 4.0;
            this.weights[2] = 0.0;
        }
        this.morph.setWeights(this.weights);
    }

    public MorphPyramid2CubeTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 7.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        MorphPyramid2CubeTest test = new MorphPyramid2CubeTest(MorphPyramid2CubeTest.parseCommandLine(args));
        test.begin();
    }
}

