/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Basic demonstration of the multipass rendering."}, authors={"Marvin Froehlich (aka Qudus)"})
public class MultipassTest
extends Xith3DTest {
    private Renderer renderer;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case L: {
                this.renderer.setLayeredMode(!this.renderer.isLayeredMode());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(SceneGraph sg, Animator animator) {
        TransformGroup tg1 = new TransformGroup();
        tg1.getTransform().setTranslation(-2.0f, 0.0f, 0.0f);
        RotatableGroup rotGroup1 = new RotatableGroup(new TransformationDirectives(0.1f, 0.1f, 0.1f));
        rotGroup1.addChild(new Cube(2.0f, 5, false, 2));
        tg1.addChild(rotGroup1);
        animator.addAnimatableObject(rotGroup1);
        TransformGroup tg2 = new TransformGroup();
        tg2.getTransform().setTranslation(0.5f, 0.0f, 0.0f);
        RotatableGroup rotGroup2 = new RotatableGroup(new TransformationDirectives(0.1f, 0.1f, 0.1f));
        rotGroup2.addChild(new Cube(0.4f, 5, false, 2));
        tg2.addChild(rotGroup2);
        animator.addAnimatableObject(rotGroup2);
        BranchGroup passGroup1 = new BranchGroup((Node)tg1);
        BranchGroup passGroup2 = new BranchGroup((Node)tg2);
        sg.addRenderPass(RenderPass.createPerspective(passGroup1));
        sg.addRenderPass(RenderPass.createParallel(passGroup2));
    }

    public MultipassTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.renderer = env.getRenderer();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, this.getAnimator());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        MultipassTest test = new MultipassTest(MultipassTest.parseCommandLine(args));
        test.begin();
    }
}

