/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Points;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Points test"}, authors={"Marvin Froehlich (aka Qudus)"})
public class PointsTest
extends Xith3DTest {
    private static final int NUM_POINTS = 2048;
    private static final float POINT_SIZE = 1.0f;
    private static final Colorf POINT_COLOR = Colorf.RED;
    private RenderPass renderPass;

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup scene = new BranchGroup();
        Random rnd = new Random(System.nanoTime());
        float MAX_RADIUS = 2.0f;
        Tuple3f[] coords = new Tuple3f[2048];
        for (int i = 0; i < 2048; ++i) {
            float d = rnd.nextFloat() * 2.0f;
            float x = rnd.nextFloat() * (float)Math.PI;
            float z = rnd.nextFloat() * (float)Math.PI;
            float s = rnd.nextBoolean() ? 1.0f : -1.0f;
            coords[i] = new Point3f(FastMath.sin(x) * FastMath.cos(z) * d, FastMath.sin(x) * FastMath.sin(z) * d * s, FastMath.cos(x) * d);
        }
        Points points = new Points(coords, 1.0f, false, POINT_COLOR);
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.2f, 0.0f));
        rg.addChild(points);
        scene.addChild(rg);
        animator.addAnimatableObject(rg);
        return scene;
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    public PointsTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        this.renderPass = env.addPerspectiveBranch(this.createSceneGraph(this.getAnimator()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        PointsTest test = new PointsTest(PointsTest.parseCommandLine(args));
        test.begin();
    }
}

