/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.loaders.MD2LoaderTest;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"This testcase demonstrates RenderToTexture for rendering", "the depth buffer into a depth texture."}, authors={"Mathias Henze (aka cylab)"})
public class RenderToTextureTest2
extends MD2LoaderTest {
    protected RenderPass init(SceneGraph sceneGraph, Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        RenderPass rp = super.init(sceneGraph, resolution, resLoc);
        BranchGroup rootBranch = rp.getBranchGroup();
        Colorf back = new Colorf(0.0f, 0.0f, 0.0f, 1.0f);
        Texture2D colorTex = TextureCreator.createTexture(TextureFormat.RGBA, 1024, 1024, back);
        colorTex.enableAutoFreeLocalData();
        TextureRenderTarget colorTarget = new TextureRenderTarget((GroupNode)rootBranch, (Texture)colorTex, back);
        sceneGraph.getRenderer().addRenderTarget((RenderTarget)colorTarget, rp.getConfig());
        Texture2D depthTex = TextureCreator.createTexture(TextureFormat.DEPTH, 1024, 1024);
        depthTex.enableAutoFreeLocalData();
        TextureRenderTarget depthTarget = new TextureRenderTarget((GroupNode)rootBranch, (Texture)depthTex, back);
        sceneGraph.getRenderer().addRenderTarget((RenderTarget)depthTarget, rp.getConfig());
        HUD hud = new HUD(resolution, 1024.0f);
        hud.getContentPane().addWidget(new Image(320.0f, 240.0f, colorTex), 10.0f, 10.0f);
        hud.getContentPane().addWidget(new Image(320.0f, 240.0f, depthTex), hud.getResX() - 330.0f, 10.0f);
        sceneGraph.addHUD(hud);
        return rp;
    }

    public RenderToTextureTest2(BasicApplicationArguments arguments) throws Throwable {
        super(arguments);
        dumpAnimationSwitches = false;
    }

    public static void main(String[] args) throws Throwable {
        RenderToTextureTest2 test = new RenderToTextureTest2(RenderToTextureTest2.parseCommandLine(args));
        test.begin();
    }
}

