/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Renderer;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.OrderedGroup;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Stencil test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class StencilTest
extends Xith3DTest {
    private RenderingAttributes ra1;
    private RenderingAttributes ra2;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.ra1.getStencilTestFunction() == RenderingAttributes.EQUAL) {
                    this.ra1.setStencilTestFunction(RenderingAttributes.ALWAYS);
                    this.ra2.setStencilTestFunction(RenderingAttributes.ALWAYS);
                    break;
                }
                this.ra1.setStencilTestFunction(RenderingAttributes.EQUAL);
                this.ra2.setStencilTestFunction(RenderingAttributes.EQUAL);
            }
        }
    }

    private void createSceneGraph(SceneGraph sg, Animator animator) {
        Group objRoot = new Group();
        OrderedGroup sets = new OrderedGroup();
        objRoot.addChild(sets);
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        TransformGroup staticGroup = new TransformGroup();
        Transform3D t2 = new Transform3D();
        t2.setIdentity();
        staticGroup.setTransform(t2);
        OrderedGroup planes = new OrderedGroup();
        staticGroup.addChild(planes);
        Rectangle rect = new Rectangle(0.9f, 1.3f, (Tuple3f)new Vector3f(-0.5f, 0.0f, -1.0f), Colorf.RED);
        rect.setName("rect_red");
        Appearance app = rect.getAppearance();
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        app.getColoringAttributes().setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.getRenderingAttributes(true).setStencilTestFunction(RenderingAttributes.ALWAYS, 1, 255);
        app.getRenderingAttributes(true).setStencilEnabled(true);
        app.getRenderingAttributes(true).setName("ra_red");
        app.getTransparencyAttributes(true).setMode(TransparencyAttributes.BLENDED);
        app.getTransparencyAttributes(true).setEnabled(false);
        planes.addChild(rect);
        rect = new Rectangle(0.9f, 1.3f, (Tuple3f)new Vector3f(0.5f, 0.0f, -1.0f), Colorf.GREEN);
        rect.setName("rect_green");
        app = rect.getAppearance();
        app.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        app.getColoringAttributes().setShadeModel(ColoringAttributes.SHADE_FLAT);
        app.getRenderingAttributes(true).setStencilTestFunction(RenderingAttributes.ALWAYS, 2, 255);
        app.getRenderingAttributes(true).setStencilEnabled(true);
        app.getRenderingAttributes(true).setName("ra_green");
        app.getTransparencyAttributes(true).setMode(TransparencyAttributes.BLENDED);
        app.getTransparencyAttributes(true).setEnabled(false);
        planes.addChild(rect);
        OrderedGroup cubes = new OrderedGroup();
        sceneRootTransform.addChild(cubes);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg", Texture.MipmapMode.BASE_LEVEL);
        Cube cube = new Cube(0.75f, texture);
        StaticTransform.translate(cube, -0.5f, 0.0f, 0.0f);
        cube.setName("cube1");
        Appearance app2 = cube.getAppearance();
        app2.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        this.ra1 = app2.getRenderingAttributes(true);
        this.ra1.setStencilTestFunction(RenderingAttributes.EQUAL, 1, 255);
        this.ra1.setStencilEnabled(true);
        this.ra1.setName("ra1");
        app2.getTransparencyAttributes(true).setMode(TransparencyAttributes.BLENDED);
        app2.getTransparencyAttributes(true).setEnabled(false);
        cubes.addChild(cube);
        cube = new Cube(0.75f, texture);
        StaticTransform.translate(cube, 0.5f, 0.0f, 0.0f);
        cube.setName("cube2");
        app2 = cube.getAppearance();
        app2.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        this.ra2 = app2.getRenderingAttributes(true);
        this.ra2.setStencilTestFunction(RenderingAttributes.EQUAL, 2, 255);
        this.ra2.setStencilEnabled(true);
        this.ra2.setName("ra2");
        app2.getTransparencyAttributes(true).setMode(TransparencyAttributes.BLENDED);
        app2.getTransparencyAttributes(true).setEnabled(false);
        cubes.addChild(cube);
        sets.addChild(staticGroup);
        sets.addChild(testRotateYGroup);
        sg.addPerspectiveBranch().getBranchGroup().addChild(objRoot);
        animator.addAnimatableObject(testRotateYGroup);
    }

    public StencilTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getRenderer().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        env.getRenderer().setTransparentSortingPolicy(Renderer.TransparentSortingPolicy.SORT_NONE);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, this.getAnimator());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle stencil function, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        StencilTest test = new StencilTest(StencilTest.parseCommandLine(args));
        test.begin();
    }
}

