/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.types.twodee.util.ResizeListener2i;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.ImageRenderTarget;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of 2 Viewports in a simple scene", "based on QuadViewportTest.<br>", "<br>", "<u>Instructions for use:</u><br>", "<br>", "<b>WARNING</b>: The following techniques may cause eyestrain or other eye problems", "and should not be done for long periods of time, if in doubt consult your optician.<br>", "<br>", "For parallel view set <i>parallel=true</i> and stare into the distance until one image is", "superimposed upon the other and you will see a 3d effect.<br>", "It can take a while for your eyes to become accustomed.", "It can help to place a sheet of paper in the center of the frame so that one eye", "isn't distracted by the image the other eye should see.<br>", "<br>", "For cross eyed viewing set <i>parallel=false</i>, place your finger in the center of the", "two images, keeping your eyes focused on your finger, move your finger towards you,", "at some point the images should become superimposed, and you will see a 3d effect."}, authors={"Marvin Froehlich (aka Qudus)", "Andy Bailey (aka hazlorealidad)"})
public class StereoViewportTest
extends Xith3DTest {
    private static boolean parallel = true;
    private Rect2i[] viewports;
    private RenderPass leftPass;
    private RenderPass rightPass;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private Rect2i[] initViewports(SceneGraph sg, Sized2iRO res, BranchGroup branchGroup) {
        int halfWidth = res.getWidth() / 2;
        int height = res.getHeight();
        this.leftPass = RenderPass.createPerspective(branchGroup);
        this.leftPass.getConfig().setViewport(new Rect2i(0, 0, halfWidth, height));
        this.rightPass = RenderPass.createPerspective(branchGroup);
        this.rightPass.getConfig().setViewport(new Rect2i(halfWidth, 0, halfWidth, height));
        Transform3D viewTransLeft = new Transform3D();
        this.leftPass.getConfig().setViewTransform(viewTransLeft);
        Transform3D viewTransRight = new Transform3D();
        this.rightPass.getConfig().setViewTransform(viewTransRight);
        sg.addRenderPass(this.leftPass);
        sg.addRenderPass(this.rightPass);
        this.leftPass.setRenderTarget(new ImageRenderTarget(this.leftPass.getBranchGroup()));
        Rect2i[] viewports = parallel ? new Rect2i[]{this.leftPass.getConfig().getViewport(), this.rightPass.getConfig().getViewport()} : new Rect2i[]{this.rightPass.getConfig().getViewport(), this.leftPass.getConfig().getViewport()};
        return viewports;
    }

    private void initGUI(SceneGraph sg, Sized2iRO res) {
        HUD hud = new HUD(res.getWidth(), res.getHeight());
        sg.addHUD(hud);
    }

    private BranchGroup createSceneGraph() {
        Cube testCube = new Cube(3.0f, "jplogo.jpg");
        BranchGroup branchGroup = new BranchGroup(testCube);
        return branchGroup;
    }

    public StereoViewportTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        View view = new View(4.0f, 4.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup branchGroup = this.createSceneGraph();
        this.viewports = this.initViewports(env, arguments.getResolution(), branchGroup);
        this.initGUI(env, arguments.getResolution());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), (parallel ? "Parallel " : "Cross Eye ") + this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        canvas.addResizeListener(new Resize());
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        StereoFirstPersonInputHandler fpHandler = new StereoFirstPersonInputHandler(view, canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 1.0f);
        fpHandler.getBindingsManager().createDefaultBindings();
        fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        StereoViewportTest test = new StereoViewportTest(StereoViewportTest.parseCommandLine(args));
        test.begin();
    }

    public class StereoFirstPersonInputHandler
    extends FirstPersonInputHandler {
        private final Vector3f tmpVec1;
        private final Vector3f tmpVec2;

        public void update(long nanoSeconds, float seconds, long nanoFrame, float frameSeconds) throws InputSystemException {
            super.update(nanoSeconds, seconds, nanoFrame, frameSeconds);
            Transformable view = this.getTransformNode();
            Transform3D trans = view.getTransform();
            StereoViewportTest.this.leftPass.getConfig().getViewTransform().set(trans);
            StereoViewportTest.this.rightPass.getConfig().getViewTransform().set(trans);
            trans.getTranslation(this.tmpVec1);
            this.tmpVec2.set(0.5f, 0.0f, 0.0f);
            trans.transform(this.tmpVec2);
            this.tmpVec2.add(this.tmpVec1);
            StereoViewportTest.this.leftPass.getConfig().getViewTransform().setTranslation(this.tmpVec2);
            this.tmpVec2.set(-0.5f, 0.0f, 0.0f);
            trans.transform(this.tmpVec2);
            this.tmpVec2.add(this.tmpVec1);
            StereoViewportTest.this.rightPass.getConfig().getViewTransform().setTranslation(this.tmpVec2);
        }

        public StereoFirstPersonInputHandler(Transformable view, int resolutionX, int resolutionY, boolean yInverted) {
            super(view, resolutionX, resolutionY, 1.0f, 1.0f, yInverted, 1.0f);
            this.tmpVec1 = new Vector3f();
            this.tmpVec2 = new Vector3f();
        }

        public StereoFirstPersonInputHandler(View view, Sized2iRO resolution, float mouseXSpeed, float mouseYSpeed, boolean yInverted, float movementSpeed) {
            super((Transformable)view, resolution, mouseXSpeed, mouseYSpeed, yInverted, movementSpeed);
            this.tmpVec1 = new Vector3f();
            this.tmpVec2 = new Vector3f();
        }
    }

    public class Resize
    implements ResizeListener2i {
        public void onObjectResized(Sized2i object, int oldWidth, int oldHeight, int newWidth, int newHeight) {
            System.out.println("Resized " + newWidth + "x" + newHeight);
            int halfWidth = newWidth / 2;
            StereoViewportTest.this.viewports[0].set(0, 0, halfWidth, newHeight);
            StereoViewportTest.this.viewports[1].set(halfWidth, 0, halfWidth, newHeight);
        }
    }
}

