/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Transparency Alpha test"}, authors={"Yuri Vl. Gushchin (aka YVG)"})
public class TransparencyAlphaTest
extends Xith3DTest {
    private RenderPass renderPass;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                if (this.renderPass.getConfig().getProjectionPolicy() == View.ProjectionPolicy.PERSPECTIVE_PROJECTION) {
                    this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PARALLEL_PROJECTION);
                    break;
                }
                this.renderPass.getConfig().setProjectionPolicy(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
            }
        }
    }

    private void createSceneGraph(GroupNode rootBranch, Animator animator) {
        Group objRoot = new Group();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        objRoot.addChild(testRotateYGroup);
        TransformGroup sceneRootTransform = new TransformGroup();
        Transform3D t = new Transform3D();
        t.setIdentity();
        sceneRootTransform.setTransform(t);
        testRotateYGroup.addChild(sceneRootTransform);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        Rectangle rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, -0.4f, 0.0f);
        Appearance rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.15f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, 0.4f, -0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.45f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, -0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.65f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        rect = new Rectangle(0.6f, 0.6f, (Texture)texture);
        StaticTransform.translate(rect, 0.4f, 0.4f, 0.0f);
        rectApp = rect.getAppearance(true);
        rectApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE));
        ta = new TransparencyAttributes();
        ta.setMode(TransparencyAttributes.BLENDED);
        ta.setTransparency(0.85f);
        rectApp.setTransparencyAttributes(ta);
        sceneRootTransform.addChild(rect);
        Appearance cubeApp = new Appearance();
        cubeApp.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        cubeApp.setTexture(texture);
        Cube cube = new Cube(0.8f, cubeApp);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.6f);
        sceneRootTransform.addChild(cube);
        rootBranch.addChild(objRoot);
        animator.addAnimatableObject(testRotateYGroup);
    }

    public TransparencyAlphaTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = new BranchGroup();
        this.createSceneGraph(rootBranch, this.getAnimator());
        this.renderPass = env.addPerspectiveBranch(rootBranch);
        this.renderPass.getConfig().setFrontClipDistance(0.1f);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TransparencyAlphaTest test = new TransparencyAlphaTest(TransparencyAlphaTest.parseCommandLine(args));
        test.begin();
    }
}

