/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.render;

import java.io.IOException;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"This testcase demonstrates Xith3D's custom vertex attributes"}, authors={"Marvin Froehlich (aka Qudus)"})
public class VertexAttributesTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    private BranchGroup createScene(ResourceLocator resLoc) throws IOException {
        BranchGroup scene = new BranchGroup();
        Tuple3f[] coords = new Point3f[]{new Point3f(-3.0f, -3.0f, 0.0f), new Point3f(3.0f, -3.0f, 0.0f), new Point3f(-3.0f, 3.0f, 0.0f), new Point3f(3.0f, 3.0f, 0.0f)};
        Colorf[] colors = new Colorf[]{Colorf.RED, Colorf.GREEN, Colorf.BLUE, Colorf.YELLOW};
        TriangleStripArray geom = new TriangleStripArray(4, null);
        geom.setCoordinates(0, coords);
        geom.setColors(0, colors);
        Shape3D rect = new Shape3D(geom);
        Tuple3f[] vertAttrs = new Tuple3f[]{new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f)};
        Tuple3f[] vertAttrs2 = new Tuple3f[]{new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f)};
        int VA_INDEX1 = 5;
        int VA_INDEX2 = 7;
        geom.setVertexAttributes(5, 0, vertAttrs);
        geom.setVertexAttributes(7, 0, vertAttrs2);
        GLSLContext.setDebuggingEnabled(true);
        GLSLVertexShader vertShader = GLSLShaderLoader.getInstance().loadVertexShader(resLoc.getResource("shader/vertex-attribs.vertex.glsl"));
        vertShader.setVertexAttributeMapping(5, "customAttrib");
        vertShader.setVertexAttributeMapping(7, "customAttrib2");
        GLSLContext shaderProg = new GLSLContext(new GLSLShaderProgram());
        ((GLSLShaderProgram)shaderProg.getProgram()).addShader(vertShader);
        rect.getAppearance(true).setShaderProgramContext(shaderProg);
        scene.addChild(rect);
        return scene;
    }

    public VertexAttributesTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL();
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(resLoc));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        VertexAttributesTest test = new VertexAttributesTest(VertexAttributesTest.parseCommandLine(args));
        test.begin();
    }
}

