/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Clipper;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Capsule;
import org.xith3d.scenegraph.primitives.Cone;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Cylinder;
import org.xith3d.scenegraph.primitives.Disk;
import org.xith3d.scenegraph.primitives.GeoSphere;
import org.xith3d.scenegraph.primitives.Ring;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.scenegraph.primitives.Torus;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.screenshots.ScreenshotEngine;

@Xith3DTest.Description(fulltext={"Test scenegraph local clipping"}, authors={"Marvin Froehlich (aka Qudus)"})
public class ClipperTest
extends Xith3DTest {
    private ScreenshotEngine screenshotEngine;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.screenshotEngine.takeScreenshot(false);
            }
        }
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup rootBranch = new BranchGroup();
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        Transform3D t3d = new Transform3D();
        TransformGroup torusTG = new TransformGroup();
        Torus torus = new Torus(20.0f, 0.5f, 32, 32, "normalmap.bmp");
        torusTG.addChild(torus);
        t3d.set(10.0f, 5.0f, 30.0f);
        torusTG.setTransform(t3d);
        rg.addChild(torusTG);
        TransformGroup capsuleTG = new TransformGroup();
        Capsule capsule = new Capsule(10.0f, 20.0f, 64, 16, "rustycan.jpg");
        StaticTransform.rotateX(capsule, 1.5707964f);
        capsuleTG.addChild(capsule);
        t3d.set(50.0f, 50.0f, 30.0f);
        capsuleTG.setTransform(t3d);
        rg.addChild(capsuleTG);
        TransformGroup sphereTG = new TransformGroup();
        Sphere sphere = new Sphere(10.0f, 16, 32, "deathstar.jpg");
        sphereTG.addChild(sphere);
        t3d.set(new Vector3f(10.0f, 30.0f, -20.0f));
        sphereTG.setTransform(t3d);
        rg.addChild(sphereTG);
        TransformGroup geoSphereTG = new TransformGroup();
        GeoSphere geoSphere = new GeoSphere(10.0f, 32, "earth.jpg");
        geoSphereTG.addChild(geoSphere);
        t3d.set(-30.0f, 30.0f, -20.0f);
        geoSphereTG.setTransform(t3d);
        rg.addChild(geoSphereTG);
        TransformGroup diskTG = new TransformGroup();
        Disk disk = new Disk(10.0f, 32, "grass.jpg");
        diskTG.addChild(disk);
        t3d.rotY(45.0f);
        t3d.setTranslation(70.0f, 40.0f, -30.0f);
        diskTG.setTransform(t3d);
        rg.addChild(diskTG);
        TransformGroup coneTG = new TransformGroup();
        Cone cone = new Cone(10.0f, 10.0f, 32, "precision.png");
        coneTG.addChild(cone);
        t3d.rotY(45.0f);
        t3d.setTranslation(50.0f, 60.0f, -30.0f);
        coneTG.setTransform(t3d);
        rg.addChild(coneTG);
        TransformGroup cylinderTG = new TransformGroup();
        Cylinder cylinder = new Cylinder(10.0f, 20.0f, 1.0f, 32, "stone.jpg");
        StaticTransform.rotateX(cylinder, 1.5707964f);
        cylinderTG.addChild(cylinder);
        t3d.rotY(45.0f);
        t3d.setTranslation(40.0f, 20.0f, -50.0f);
        cylinderTG.setTransform(t3d);
        rg.addChild(cylinderTG);
        TransformGroup ringTG = new TransformGroup();
        Ring ring = new Ring(10.0f, 0.7f, 32, "saturnringcolor.jpg");
        StaticTransform.rotateX(ring, 1.5707964f);
        ringTG.addChild(ring);
        t3d.rotY(45.0f);
        t3d.setTranslation(-40.0f, 20.0f, -50.0f);
        ringTG.setTransform(t3d);
        rg.addChild(ringTG);
        TransformGroup cubeTG = new TransformGroup();
        Cube cube = new Cube(10.0f, "jplogo.jpg");
        StaticTransform.translate(cube, 5.0f, 5.0f, 5.0f);
        cubeTG.addChild(cube);
        t3d.set(20.0f, -10.0f, -30.0f);
        cubeTG.setTransform(t3d);
        rg.addChild(cubeTG);
        rootBranch.addChild(rg);
        animator.addAnimatableObject(rg);
        Clipper clipper = new Clipper(new Plane(1.0f, 0.0f, 0.0f, 0.0f));
        rootBranch.setClipper(clipper);
        return rootBranch;
    }

    public ClipperTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(25.0f, 20.0f, 200.0f, 0.0f, 20.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFieldOfView(FastMath.toRad(22.5f));
        this.screenshotEngine = env.getScreenshotEngine();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = this.createSceneGraph(this.getAnimator());
        env.addBranchGraph(rootBranch, new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, 0.01f, 400.0f));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static final void main(String[] args) throws Throwable {
        ClipperTest test = new ClipperTest(ClipperTest.parseCommandLine(args));
        test.begin();
    }
}

