/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.LODShape3D;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the LODShape3D<br>", "The LODShape3D handles multiple Geometries, that represent the", "same thing, but in different levels of detail."}, authors={"Marvin Froehlich (aka Qudus)"})
public class LODShape3DTest
extends Xith3DTest {
    private Canvas3D canvas;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.canvas.switchWireframeMode();
            }
        }
    }

    private void initSceneGraph(SceneGraph sg) {
        BranchGroup scene = new BranchGroup();
        LODShape3D lodShape = new LODShape3D();
        int geomFeatures = 11;
        Appearance app = new Appearance();
        app.setTexture("deathstar.jpg");
        Geometry geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 10.0f, 128, 128, geomFeatures, false, 2);
        lodShape.addLOD(0.0f, 20.0f, geom, app);
        geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 10.0f, 64, 64, geomFeatures, false, 2);
        lodShape.addLOD(19.0f, 35.0f, geom, app);
        geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 10.0f, 16, 16, geomFeatures, false, 2);
        lodShape.addLOD(34.0f, 50.0f, geom, app);
        geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 10.0f, 8, 8, geomFeatures, false, 2);
        lodShape.addLOD(49.0f, 75.0f, geom, app);
        geom = Sphere.createGeometry(0.0f, 0.0f, 0.0f, 10.0f, 4, 4, geomFeatures, false, 2);
        lodShape.addLOD(74.0f, Float.MAX_VALUE, geom, app);
        scene.addChild(lodShape);
        sg.addPerspectiveBranch(scene);
    }

    public LODShape3DTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.initSceneGraph(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.canvas.setWireframeMode(true);
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpih = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)this.canvas, arguments.getMouseYInverted());
        fpih.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        LODShape3DTest test = new LODShape3DTest(LODShape3DTest.parseCommandLine(args));
        test.begin();
    }
}

