/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.LODSwitch;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the LODSwitch<br>", "The LODSwitch handles multiple Nodes, that represent the", "same Node, but in different levels of detail."}, authors={"Marvin Froehlich (aka Qudus)", "Mathias Henze (aka cylab)"})
public class NestedLODSwitchTest
extends Xith3DTest {
    private Canvas3D canvas;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
            case SPACE: {
                this.canvas.switchWireframeMode();
            }
        }
    }

    private void initSceneGraph(SceneGraph sg) {
        BranchGroup scene = new BranchGroup();
        LODSwitch lodSwitch1 = new LODSwitch();
        Rectangle rect00 = new Rectangle(2.0f, 2.0f, "countdown_q.png");
        lodSwitch1.addLODItem(rect00, 0.0f, 2.0f);
        Rectangle rect01 = new Rectangle(2.0f, 2.0f, "countdown_1.png");
        lodSwitch1.addLODItem(rect01, 2.0f, 4.0f);
        Rectangle rect02 = new Rectangle(2.0f, 2.0f, "countdown_2.png");
        lodSwitch1.addLODItem(rect02, 4.0f, 6.0f);
        Rectangle rect03 = new Rectangle(2.0f, 2.0f, "countdown_3.png");
        lodSwitch1.addLODItem(rect03, 6.0f, 10.0f);
        LODSwitch lodSwitch2 = new LODSwitch();
        lodSwitch2.addLODItem(lodSwitch1, 0.0f, 10.0f);
        Rectangle rect10 = new Rectangle(5.0f, 5.0f, "countdown_q.png");
        lodSwitch2.addLODItem(rect10, 10.0f, 15.0f);
        Rectangle rect11 = new Rectangle(5.0f, 5.0f, "countdown_1.png");
        lodSwitch2.addLODItem(rect11, 15.0f, 20.0f);
        Rectangle rect12 = new Rectangle(5.0f, 5.0f, "countdown_2.png");
        lodSwitch2.addLODItem(rect12, 20.0f, 25.0f);
        Rectangle rect13 = new Rectangle(5.0f, 5.0f, "countdown_3.png");
        lodSwitch2.addLODItem(rect13, 25.0f, 30.0f);
        LODSwitch lodSwitch3 = new LODSwitch();
        lodSwitch3.addLODItem(lodSwitch2, 0.0f, 30.0f);
        Rectangle rect20 = new Rectangle(10.0f, 10.0f, "countdown_q.png");
        lodSwitch3.addLODItem(rect20, 30.0f, 35.0f);
        Rectangle rect21 = new Rectangle(10.0f, 10.0f, "countdown_1.png");
        lodSwitch3.addLODItem(rect21, 35.0f, 40.0f);
        Rectangle rect22 = new Rectangle(10.0f, 10.0f, "countdown_2.png");
        lodSwitch3.addLODItem(rect22, 40.0f, 45.0f);
        Rectangle rect23 = new Rectangle(10.0f, 10.0f, "countdown_3.png");
        lodSwitch3.addLODItem(rect23, 45.0f, Float.MAX_VALUE);
        scene.addChild(lodSwitch3);
        sg.addPerspectiveBranch(scene);
    }

    public NestedLODSwitchTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 50.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.initSceneGraph(env);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.canvas.setWireframeMode(false);
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        FirstPersonInputHandler fpih = new FirstPersonInputHandler((Transformable)env.getView(), this.canvas, 0.3f, 0.3f, arguments.getMouseYInverted(), 0.3f);
        fpih.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        NestedLODSwitchTest test = new NestedLODSwitchTest(NestedLODSwitchTest.parseCommandLine(args));
        test.begin();
    }
}

