/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import java.net.URL;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorURL;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.SkyGeoHemisphere;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the SkyGeoHemisphere class."}, authors={"Kevin Finley (aka horati)"})
public class SkyGeoHemisphereTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public static SkyGeoHemisphere createSkyGeoHemisphere(URL baseURL, String name) {
        long t0 = TestUtils.dumpAction("Creating SkyGeoHemisphere from \"" + baseURL + name);
        TextureStreamLocatorURL tsl = TextureLoader.getInstance().addTextureStreamLocator(baseURL);
        SkyGeoHemisphere sgh = new SkyGeoHemisphere(name);
        TextureLoader.getInstance().removeTextureStreamLocator(tsl);
        TestUtils.dumpDoneIn(t0);
        return sgh;
    }

    public SkyGeoHemisphereTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(SkyGeoHemisphereTest.createSkyGeoHemisphere(resLoc.getResource("skyboxes/"), "508d20-4500.jpg"));
        BranchGroup scene = new BranchGroup();
        scene.addChild(new Sphere(64, 64, "deathstar.jpg"));
        env.addPerspectiveBranch(scene);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpHandler = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpHandler.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        SkyGeoHemisphereTest test = new SkyGeoHemisphereTest(SkyGeoHemisphereTest.parseCommandLine(args));
        test.begin();
    }
}

