/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.scenegraph;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.SkyGeoSphere;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple test of the SkyGeoSphere class."}, authors={"Kevin Finley (aka horati)", "Marvin Froehlich (aka Qudus)"})
public class SkyGeoSphereTest
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    public static SkyGeoSphere createSkyGeoSphere() {
        SkyGeoSphere sgs = new SkyGeoSphere("earth.jpg");
        return sgs;
    }

    public SkyGeoSphereTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(SkyGeoSphereTest.createSkyGeoSphere());
        BranchGroup scene = new BranchGroup();
        scene.addChild(new Sphere(64, 64, "deathstar.jpg"));
        env.addPerspectiveBranch(scene);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpHandler = FirstPersonInputHandler.createDefault((Transformable)env.getView(), (Sized2iRO)canvas, arguments.getMouseYInverted());
        fpHandler.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        SkyGeoSphereTest test = new SkyGeoSphereTest(SkyGeoSphereTest.parseCommandLine(args));
        test.begin();
    }
}

