/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.selection;

import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.selection.BoundingBoxSelectable;
import org.xith3d.selection.HUDContextMenuProvider;
import org.xith3d.selection.MenuAction;
import org.xith3d.selection.Selectable;
import org.xith3d.selection.SelectionListener;
import org.xith3d.selection.SelectionManager;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.dialogs.MsgBox;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Simple Xith3D Selection Framework (work in progress) Test"}, authors={"Mathias Henze (aka cylab)"})
public class SelectionTest
extends Xith3DTest {
    private Canvas3D canvas;
    private BranchGroup rootBranch;
    private HUD hud;
    private SelectionManager selectionManager = new SelectionManager();
    private ResourceLocator resLoc;
    private FirstPersonInputHandler moveHandler;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                this.moveHandler.setMouseMovementSuspended(!this.moveHandler.isMouseMovementSuspended());
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createSceneGraph() {
        BranchGroup scene = new BranchGroup();
        scene.addChild(new AmbientLight(Colorf.WHITE));
        TransformGroup topTransform = new TransformGroup(0.0f, 0.5f, 0.0f);
        TransformGroup cubeTransform = new TransformGroup(-1.0f, -1.0f, 1.0f);
        TransformGroup sphereTransform = new TransformGroup(1.0f, -1.0f, 1.0f);
        TransformGroup modelTransform = new TransformGroup(0.0f, -1.0f, -1.0f);
        Cube cube = new Cube(0.5f, "jplogo.jpg");
        cube.setName("Cube");
        BoundingBoxSelectable<Cube> cubeSelectable = new BoundingBoxSelectable<Cube>(cube);
        cubeSelectable.register(new MenuAction("Action1"){

            public void onActionPerformed() {
                MsgBox.show("Clicked " + this.getName(), SelectionTest.this.hud);
            }
        });
        cubeSelectable.register(new MenuAction("Action2"){

            public void onActionPerformed() {
                MsgBox.show("Clicked " + this.getName(), SelectionTest.this.hud);
            }
        });
        cubeSelectable.register(MenuAction.SEPARATOR);
        cubeSelectable.register(new MenuAction("Action3"){

            public void onActionPerformed() {
                MsgBox.show("Clicked " + this.getName(), SelectionTest.this.hud);
            }
        });
        cube.setUserData(Selectable.class, cubeSelectable);
        cubeTransform.addChild(cube);
        topTransform.addChild(cubeTransform);
        Sphere sphere = new Sphere(0.25f, 16, 16, "deathstar.jpg");
        sphere.setName("Sphere");
        sphere.setUserData(Selectable.class, new BoundingBoxSelectable<Sphere>(sphere));
        sphereTransform.addChild(sphere);
        topTransform.addChild(sphereTransform);
        try {
            Model model = ModelLoader.getInstance().loadModel(this.resLoc.getResource("models/tris.md2"), "marvin.pcx", 0.02f);
            TransformGroup tg = new TransformGroup();
            tg.getTransform().setRotation(new AxisAngle3f(Vector3f.POSITIVE_Y_AXIS, -1.5707964f));
            tg.addChild(model);
            model.setCurrentAnimation("salute");
            model.setUserData(Selectable.class, new BoundingBoxSelectable<Model>(model));
            modelTransform.addChild(tg);
            topTransform.addChild(modelTransform);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        scene.addChild(topTransform);
        return scene;
    }

    private Group createCrossHair() {
        Group crossHair = new Group();
        float o1 = 0.05f;
        float o2 = 0.034f;
        float i1 = 0.02f;
        float i2 = 0.01f;
        Colorf oc = Colorf.GREEN;
        Colorf ic = Colorf.LIGHT_GRAY;
        Colorf cc = Colorf.WHITE;
        Line[] lines = new Line[]{new Line((Tuple3f)new Point3f(-o1, o1, 0.0f), new Point3f(-o2, o1, 0.0f), oc), new Line((Tuple3f)new Point3f(o1, o1, 0.0f), new Point3f(o2, o1, 0.0f), oc), new Line((Tuple3f)new Point3f(-o1, o1, 0.0f), new Point3f(-o1, o2, 0.0f), oc), new Line((Tuple3f)new Point3f(o1, o1, 0.0f), new Point3f(o1, o2, 0.0f), oc), new Line((Tuple3f)new Point3f(-o1, -o1, 0.0f), new Point3f(-o2, -o1, 0.0f), oc), new Line((Tuple3f)new Point3f(o1, -o1, 0.0f), new Point3f(o2, -o1, 0.0f), oc), new Line((Tuple3f)new Point3f(-o1, -o1, 0.0f), new Point3f(-o1, -o2, 0.0f), oc), new Line((Tuple3f)new Point3f(o1, -o1, 0.0f), new Point3f(o1, -o2, 0.0f), oc), new Line((Tuple3f)new Point3f(-i1, i1, 0.0f), new Point3f(-i2, i1, 0.0f), ic), new Line((Tuple3f)new Point3f(i1, i1, 0.0f), new Point3f(i2, i1, 0.0f), ic), new Line((Tuple3f)new Point3f(-i1, i1, 0.0f), new Point3f(-i1, i2, 0.0f), ic), new Line((Tuple3f)new Point3f(i1, i1, 0.0f), new Point3f(i1, i2, 0.0f), ic), new Line((Tuple3f)new Point3f(-i1, -i1, 0.0f), new Point3f(-i2, -i1, 0.0f), ic), new Line((Tuple3f)new Point3f(i1, -i1, 0.0f), new Point3f(i2, -i1, 0.0f), ic), new Line((Tuple3f)new Point3f(-i1, -i1, 0.0f), new Point3f(-i1, -i2, 0.0f), ic), new Line((Tuple3f)new Point3f(i1, -i1, 0.0f), new Point3f(i1, -i2, 0.0f), ic), new Line((Tuple3f)new Point3f(-i2, 0.0f, 0.0f), new Point3f(i2, 0.0f, 0.0f), cc), new Line((Tuple3f)new Point3f(0.0f, -i2, 0.0f), new Point3f(0.0f, i2, 0.0f), cc)};
        for (int i = 0; i < lines.length; ++i) {
            crossHair.addChild(lines[i]);
        }
        return crossHair;
    }

    private HUD createHUD(Sized2iRO canvasRes, SceneGraph sceneGraph) {
        HUD hud = new HUD(canvasRes, 800.0f);
        sceneGraph.addHUD(hud);
        return hud;
    }

    public SelectionTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        this.resLoc = TestUtils.createResourceLocator();
        this.resLoc.createAndAddTSL("textures");
        this.rootBranch = this.createSceneGraph();
        env.addPerspectiveBranch(this.rootBranch);
        this.hud = this.createHUD(arguments.getResolution(), env);
        RenderPass pass = RenderPass.createParallel(View.CameraMode.VIEW_FIXED);
        pass.getBranchGroup().addChild(this.createCrossHair());
        env.addRenderPass(pass);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        this.selectionManager.bind(this.rootBranch, this.canvas);
        this.selectionManager.setContextMenuProvider(new HUDContextMenuProvider(this.hud));
        this.selectionManager.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(List<Selectable> selection, List<Selectable> selectedContext) {
                for (int i = 0; i < selection.size(); ++i) {
                    Selectable selectable = selection.get(i);
                    Node node2 = selectable.getNode();
                    System.out.println("Selected " + node2.getName());
                }
            }

            @Override
            public void selectionMoved(List<Selectable> selection, List<Selectable> selectedContext, Vector3f delta) {
                for (int i = 0; i < selection.size(); ++i) {
                    Selectable selectable = selection.get(i);
                    Node node2 = selectable.getNode();
                    System.out.println(node2.getName() + " moved");
                }
            }
        });
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        InputSystem.getInstance().getMouse().addMouseListener(this.selectionManager);
        this.hud.addPickMissedListener(SelectionManager.HUD_PICK_MISSED_MASK, this.selectionManager);
        this.moveHandler = new FirstPersonInputHandler((Transformable)env.getView(), env.getCanvas(), 0.5f, 0.5f, arguments.getMouseYInverted(), 0.5f);
        this.moveHandler.setMouseMovementSuspended(true);
        this.moveHandler.getBindingsManager().createDefaultBindings();
        this.moveHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(this.moveHandler);
    }

    public static void main(String[] args) throws Throwable {
        SelectionTest test = new SelectionTest(SelectionTest.parseCommandLine(args));
        test.begin();
    }
}

