/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.shaders;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.celshading.AssemblyCelShadingFactory;
import org.xith3d.effects.celshading.CelShadingFactory;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.JCDModelLoader;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Demonstrates cel-shading."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CelShadingTest
extends Xith3DTest {
    private static final boolean USE_VERTEX_SHADER = true;
    private RotatableGroup rotGroup = null;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                if (this.rotGroup.isAnimating()) {
                    this.rotGroup.stopAnimation();
                    break;
                }
                this.rotGroup.startAnimation(this.getGameTime(), this.getTimingMode());
                break;
            }
            case NUMPAD_ADD: {
                CelShadingFactory.setOutlineLineWidth(CelShadingFactory.getOutlineLineWidth() + 1.0f);
                break;
            }
            case NUMPAD_SUBTRACT: {
                CelShadingFactory.setOutlineLineWidth(CelShadingFactory.getOutlineLineWidth() - 1.0f);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene(ResourceLocator resLoc, Animator animator) throws Exception {
        BranchGroup scene = new BranchGroup();
        TriangleArray model = JCDModelLoader.readModelMesh(resLoc.getResource("models/robot.jcd"));
        model.setOptimization(Geometry.Optimization.USE_DISPLAY_LISTS);
        this.rotGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.15f, 0.0f));
        EffectFactory.getInstance().getCelShadingFactory().prepareForCelShading(model, this.rotGroup);
        scene.addChild(this.rotGroup);
        animator.addAnimatableObject(this.rotGroup, false);
        return scene;
    }

    public CelShadingTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFieldOfView(FastMath.toRad(22.5f));
        EffectFactory.getInstance().registerCelShadingFactory(new AssemblyCelShadingFactory());
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        env.addPerspectiveBranch(this.createScene(resLoc, this.getAnimator()));
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.GRAY30);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        CelShadingTest test = new CelShadingTest(CelShadingTest.parseCommandLine(args));
        test.begin();
    }
}

