/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.shaders;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.animations.ModelAnimation;
import org.xith3d.loaders.texture.TextureCreator;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.scenegraph.SkyBoxTest;
import org.xith3d.test.shaders.ControlSpec;
import org.xith3d.test.shaders.Effect;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.listeners.SliderListener;
import org.xith3d.ui.hud.widgets.Slider;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.interpolate.AngleInterpolater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Xith3DTest.Description(fulltext={"A simple example how to apply post effects using render to texture and GLSL shaders"}, authors={"Mathias Henze (aka cylab)"})
public class PostEffectsTest
extends Xith3DTest
implements SliderListener {
    private GLSLContext shaderProg;
    private Model model;
    private ModelAnimation[] anims;
    private int currentAnim = 0;
    private DirectionalLight direcLight;
    private long animTime = 0L;
    private AngleInterpolater lightAngle = new AngleInterpolater(0.0f, 1.0f, 0.0f, (float)Math.PI * 2, true);

    @Override
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    @Override
    protected void onRenderLoopStarted() {
        this.lightAngle.startIncreasing(0L);
    }

    @Override
    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        long micros = timingMode.getMicroSeconds(gameTime);
        float lightAngleValue = this.lightAngle.getValue(gameTime);
        Vector3f dir = new Vector3f(FastMath.cos(lightAngleValue), FastMath.sin(lightAngleValue), -1.0f);
        this.direcLight.setDirection(dir);
        if (micros - this.animTime >= 3000000L) {
            this.currentAnim = (this.currentAnim + 1) % this.anims.length;
            this.model.setCurrentAnimation(this.anims[this.currentAnim]);
            this.animTime = micros;
        }
    }

    private Group loadModel(URL modelResource, String skin) {
        long t0 = TestUtils.dumpAction("Loading MD2Model \"" + modelResource + "\"...");
        Group group = new Group();
        group.addChild(new AmbientLight(Colorf.GRAY50));
        this.direcLight = new DirectionalLight(true, Colorf.MAGENTA, Vector3f.POSITIVE_X_AXIS);
        group.addChild(this.direcLight);
        try {
            this.model = ModelLoader.getInstance().loadModel(modelResource, skin, 0.04f);
            this.anims = this.model.getAnimations();
            this.model.setCurrentAnimation(this.anims[this.currentAnim]);
            group.addChild(this.model);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        TestUtils.dumpDoneIn(t0);
        return group;
    }

    private Node createFloor() {
        long t0 = TestUtils.dumpAction("Creating floor...");
        Rectangle floor = new Rectangle(2.8f, 3.4f, "grass.jpg");
        floor.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        StaticTransform.rotateX(floor, -1.5707964f);
        StaticTransform.translate(floor, -1.2f, -1.5f, 0.0f);
        TestUtils.dumpDoneIn(t0);
        return floor;
    }

    private GLSLFragmentShader generateEffectShader(List<Effect> effects) {
        String shaderSource = "uniform sampler2D image;";
        for (Effect e : effects) {
            shaderSource = shaderSource + e.getHeader();
        }
        shaderSource = shaderSource + "void main(void){vec4 _pixel=texture2D(image,gl_TexCoord[0].st);float alpha=_pixel.a;vec3 color=vec3(_pixel);";
        for (Effect e : effects) {
            shaderSource = shaderSource + e.getBody();
        }
        shaderSource = shaderSource + "gl_FragColor=vec4(color,alpha);}";
        return new GLSLFragmentShader(shaderSource);
    }

    @Override
    public void onSliderValueChanged(Slider slider, int newValue) {
        ControlSpec spec = (ControlSpec)slider.getUserObject();
        this.shaderProg.getUniformParameters().setUniformVar(spec.getName(), (float)newValue / 100.0f * spec.getUnit());
    }

    protected void init(SceneGraph sceneGraph, Sized2iRO resolution, ResourceLocator resLoc) throws Exception {
        sceneGraph.addRenderPass(SkyBoxTest.createSkyBox(resLoc.getResource("skyboxes/"), "normal"));
        resLoc.createAndAddTSL("textures");
        BranchGroup rootBranch = new BranchGroup();
        RenderPass rp = sceneGraph.addPerspectiveBranch(rootBranch);
        rootBranch.addChild(this.createFloor());
        Group model = this.loadModel(resLoc.getResource("models/tris.md2"), "marvin.pcx");
        model.updateWorldTransform();
        Texture2D targetTex = TextureCreator.createTexture(TextureFormat.RGBA, 1024, 1024, Colorf.BLACK_TRANSPARENT);
        TextureRenderTarget renderTarget = new TextureRenderTarget((GroupNode)model, (Texture)targetTex, Colorf.BLACK_TRANSPARENT);
        sceneGraph.getRenderer().addRenderTarget((RenderTarget)renderTarget, rp.getConfig());
        Rectangle target = new Rectangle(2.0f, 2.0f / resolution.getAspect(), (Texture)targetTex);
        Appearance appearance = target.getAppearance();
        GLSLVertexShader vertexShader = new GLSLVertexShader("void main(void){\n    gl_TexCoord[0]=gl_MultiTexCoord0;\n    gl_Position=ftransform();\n}");
        Effect saturation = new Effect("Saturation", "Adjusts the saturation of the picture", new ControlSpec[]{new ControlSpec("float", "sat", "Saturation", "", 1.0f)}, "const vec3 lumCoeff = vec3 (0.2125, 0.7154, 0.0721);uniform float sat;", "vec3 satInt= vec3(dot(color, lumCoeff));color= vec4(mix(satInt, color, sat),1.0);");
        Effect brightness = new Effect("Brightness", "Adjusts the brightness of the picture", new ControlSpec[]{new ControlSpec("float", "bright", "Brightness", "", 1.0f)}, "uniform float bright;", "color=color*bright;");
        Effect blur = new Effect("Blur", "Blurs the picture", new ControlSpec[]{new ControlSpec("float", "sampleDist", "Sample Distance", "", 0.01f)}, "uniform float sampleDist;", "vec4 blurred;blurred  = texture2D(image,gl_TexCoord[0].st);blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.326212, -0.405805));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.840144, -0.073580));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.695914,  0.457137));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.203345,  0.620716));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.962340, -0.194983));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.473434, -0.480026));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.519456,  0.767022));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.185461, -0.893124));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.507431,  0.064425));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(0.896420,  0.412458));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.321940, -0.932615));blurred += texture2D(image,gl_TexCoord[0].st + sampleDist * vec2(-0.791559, -0.597705));color = blurred/13.0;");
        ArrayList<Effect> effects = new ArrayList<Effect>();
        effects.add(blur);
        effects.add(saturation);
        effects.add(brightness);
        GLSLFragmentShader fragmentShader = this.generateEffectShader(effects);
        this.shaderProg = new GLSLContext(new GLSLShaderProgram(vertexShader, fragmentShader));
        GLSLParameters params = this.shaderProg.getUniformParameters();
        params.setUniformVar("image", 0);
        params.setUniformVar("sampleDist", 0.0f);
        params.setUniformVar("bright", 2.0f);
        params.setUniformVar("sat", 0.5f);
        appearance.setShaderProgramContext(this.shaderProg);
        target.setAppearance(appearance);
        StaticTransform.translate(target, 0.0f, 0.0f, -1.0f);
        RenderPass effectPass = sceneGraph.addParallelBranch();
        effectPass.getConfig().setViewTransform(Transform3D.IDENTITY);
        effectPass.getBranchGroup().addChild(target);
        HUD hud = new HUD(resolution, 1024.0f);
        Slider slider = new Slider(265.0f);
        slider.setMinMaxAndValue(0, 400, 0);
        slider.setSmoothSliding(true);
        slider.addSliderListener(this);
        slider.setUserObject(blur.getControlSpecs()[0]);
        hud.getContentPane().addWidget(slider, 32.0f, 580.0f);
        slider = new Slider(265.0f);
        slider.setMinMaxAndValue(0, 400, 0);
        slider.setSmoothSliding(true);
        slider.addSliderListener(this);
        slider.setUserObject(saturation.getControlSpecs()[0]);
        hud.getContentPane().addWidget(slider, 32.0f, 620.0f);
        slider = new Slider(265.0f);
        slider.setMinMaxAndValue(0, 400, 0);
        slider.setSmoothSliding(true);
        slider.addSliderListener(this);
        slider.setUserObject(brightness.getControlSpecs()[0]);
        hud.getContentPane().addWidget(slider, 32.0f, 660.0f);
        sceneGraph.addHUD(hud);
    }

    public PostEffectsTest(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(2.41f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        this.init(env, arguments.getResolution(), resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.enableLighting();
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        PostEffectsTest test = new PostEffectsTest(PostEffectsTest.parseCommandLine(args));
        test.begin();
    }
}

