/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.sound;

import java.util.Random;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.FastMath;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.sound.SoundLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BackgroundSound;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointSound;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.sound.drivers.joal.SoundDriverImpl;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Tests Xith3D's sound system using JOAL as OpenAL binding."}, authors={"David Yazel", "Marvin Froehlich (aka Qudus)"})
public class JOALSoundTest
extends Xith3DTest
implements IntervalListener {
    private SoundDriver soundDriver;
    private Transform3D t3dRotate;
    private Transform3D t3dTranslate;
    private Vector3f translation;
    private TransformGroup tf_1;
    private TransformGroup tf_2;
    private float angle = 0.0f;
    private float translateValue = 0.0f;
    private float translateDir = 1.0f;
    private float xTranslateValue = 0.0f;
    private float xTranslateDir = 1.0f;
    private int stage = 1;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup root = new BranchGroup();
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        texture.setFilter(TextureFilter.TRILINEAR);
        this.t3dRotate = new Transform3D();
        this.t3dTranslate = new Transform3D();
        this.translation = new Vector3f();
        this.tf_1 = new TransformGroup(this.t3dTranslate);
        this.tf_2 = new TransformGroup(this.t3dRotate);
        root.addChild(this.tf_1);
        this.tf_1.addChild(this.tf_2);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        Random ran = new Random(System.nanoTime());
        for (int i = 0; i < 300; ++i) {
            Cube cube = new Cube(0.3f, a);
            StaticTransform.translate(cube, 4.0f - 8.0f * ran.nextFloat(), 4.0f - 8.0f * ran.nextFloat(), 4.0f - 8.0f * ran.nextFloat());
            this.tf_2.addChild(cube);
        }
        this.soundDriver = new SoundDriverImpl();
        SoundProcessor.getInstance().setSoundDriver(this.soundDriver);
        this.soundDriver.setListenerVolume(1.0f);
        SoundContainer sc = SoundLoader.getInstance().loadSound(resLoc.getResource("sounds/jog_on_grass.ogg"));
        PointSound sound = new PointSound(sc, 1.0f);
        sound.setEnabled(true);
        this.tf_2.addChild(sound);
        SoundContainer sc2 = SoundLoader.getInstance().loadSound(resLoc.getResource("sounds/birds.ogg"));
        BackgroundSound sound2 = new BackgroundSound(sc2, 1.0f);
        sound2.setEnabled(true);
        this.tf_2.addChild(sound2);
        env.addPerspectiveBranch(root);
    }

    public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (interval.getName().equals("STAGE-2")) {
            this.stage = 2;
            interval.setName("STAGE-3");
        } else if (interval.getName().equals("STAGE-3")) {
            this.stage = 3;
            interval.setName("STAGE-4");
            interval.kill();
            this.end();
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        switch (this.stage) {
            case 1: {
                this.t3dRotate.rotXYZ(this.angle, this.angle, this.angle);
                this.tf_2.setTransform(this.t3dRotate);
                this.translation.setX(this.xTranslateValue);
                this.translation.setZ(-3.0f);
                this.t3dTranslate.setTranslation(this.translation);
                this.tf_1.setTransform(this.t3dTranslate);
                if (this.translateDir > 0.0f) {
                    this.translateValue = (float)((double)this.translateValue + 0.1);
                    if (this.translateValue >= 10.0f) {
                        this.translateDir = -1.0f;
                    }
                } else {
                    this.translateValue = (float)((double)this.translateValue - 0.1);
                    if (this.translateValue <= -30.0f) {
                        this.translateDir = 1.0f;
                    }
                }
                if (this.xTranslateDir > 0.0f) {
                    this.xTranslateValue = (float)((double)this.xTranslateValue + 0.05);
                    if (this.xTranslateValue >= 15.0f) {
                        this.xTranslateDir = -1.0f;
                    }
                } else {
                    this.xTranslateValue = (float)((double)this.xTranslateValue - 0.05);
                    if (this.xTranslateValue <= -15.0f) {
                        this.xTranslateDir = 1.0f;
                    }
                }
                this.angle = 0.0f;
                break;
            }
            case 2: {
                this.t3dRotate.rotXYZ(this.angle, this.angle, this.angle);
                this.tf_2.setTransform(this.t3dRotate);
                this.translation.setX(0.0f);
                this.translation.setZ(-3.0f + this.translateValue);
                this.t3dTranslate.setTranslation(this.translation);
                this.tf_1.setTransform(this.t3dTranslate);
                if (this.translateDir > 0.0f) {
                    this.translateValue = (float)((double)this.translateValue + 0.1);
                    if (this.translateValue >= 10.0f) {
                        this.translateDir = -1.0f;
                    }
                } else {
                    this.translateValue = (float)((double)this.translateValue - 0.1);
                    if (this.translateValue <= -40.0f) {
                        this.translateDir = 1.0f;
                    }
                }
                this.angle = 0.0f;
            }
        }
    }

    protected void onRenderLoopStarted() {
        this.soundDriver.start();
    }

    protected void onRenderLoopStopped(long gameTime, UpdatingThread.TimingMode timingMode, float averageFPS) {
        this.soundDriver.shutdown();
    }

    public JOALSoundTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setFieldOfView(FastMath.toRad(35.0f));
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        this.getOperationScheduler().addInterval(new Interval(10000L, "STAGE-1"));
        this.getOperationScheduler().addIntervalListener(this);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        JOALSoundTest test = new JOALSoundTest(JOALSoundTest.parseCommandLine(args));
        test.begin();
    }
}

