/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.sound;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.sound.impl.wav.WaveLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointSound;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.sound.SoundDriver;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.sound.drivers.joal.SoundDriverImpl;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Tests the PointSound Node."}, authors={"Marvin Froehlich (aka Qudus)"})
public class PointSoundTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private final PointSound createSound(ResourceLocator resLoc, String objFileName) throws Exception {
        PointSound sound = new WaveLoader().loadPointSound(resLoc.getResource(objFileName), 1.0f);
        sound.setSchedulingBounds(new BoundingSphere(0.0f, 0.0f, 0.0f, 1000.0f));
        sound.setEnabled(true);
        sound.setContinuousEnabled(true);
        return sound;
    }

    private final BranchGroup createSceneGraph(Xith3DEnvironment env, ResourceLocator resLoc) throws Exception {
        BranchGroup scene = new BranchGroup();
        SoundDriverImpl soundDriver = new SoundDriverImpl();
        SoundProcessor.getInstance().setSoundDriver(soundDriver);
        ((SoundDriver)soundDriver).setListenerVolume(1.0f);
        soundDriver.start();
        Point3f soundLoc = new Point3f(0.0f, 0.0f, 0.0f);
        Sphere sphere = new Sphere(0.1f, 8, 8, "earth.jpg");
        StaticTransform.translate(sphere, (Tuple3f)soundLoc);
        scene.addChild(sphere);
        scene.addChild(this.createSound(resLoc, "sounds/kidscheer.wav"));
        env.addPerspectiveBranch(scene);
        return scene;
    }

    public PointSoundTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env, resLoc);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpHandler = new FirstPersonInputHandler((Transformable)env.getView(), env.getCanvas(), 1.0f, 1.0f, arguments.getMouseYInverted(), 0.3f);
        fpHandler.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        PointSoundTest test = new PointSoundTest(PointSoundTest.parseCommandLine(args));
        test.begin();
    }
}

