/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import org.jagatoo.opengl.enums.TextureMode;
import org.openmali.vecmath2.TexCoord2f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.terrain.GridSurface;

public class DetailTextureSurface
implements GridSurface {
    private Appearance appearance;
    private float detailRepeat = 4.0f;

    public DetailTextureSurface(String colorTexture) {
        this(colorTexture, null, 0.0f, null);
    }

    public DetailTextureSurface(String colorTexture, Material material) {
        this(colorTexture, null, 0.0f, null, material);
    }

    public DetailTextureSurface(String colorTexture, String detailTexture, float detailRepeat, TextureMode blendMode) {
        this(colorTexture, detailTexture, detailRepeat, blendMode, new Material());
        this.getAppearance().getMaterial().setLightingEnabled(false);
    }

    public DetailTextureSurface(String colorTexture, String detailTexture, float detailRepeat, TextureMode blendMode, Material material) {
        Appearance a = new Appearance();
        a.setMaterial(material);
        this.detailRepeat = detailRepeat;
        TextureLoader tl = TextureLoader.getInstance();
        if (detailTexture == null) {
            a.setTexture(tl.getTexture(colorTexture, Texture.MipmapMode.BASE_LEVEL));
        } else {
            TextureAttributes colorAttrs = new TextureAttributes(TextureAttributes.REPLACE, null, null, TextureAttributes.NICEST);
            TextureUnit color = new TextureUnit(tl.getTexture(colorTexture, Texture.MipmapMode.BASE_LEVEL), colorAttrs);
            TextureAttributes detailAttrs = new TextureAttributes(blendMode, null, null, TextureAttributes.NICEST);
            TextureUnit details = new TextureUnit(tl.getTexture(detailTexture, Texture.MipmapMode.MULTI_LEVEL_MIPMAP), detailAttrs);
            a.setTextureUnits(color, details);
        }
        this.appearance = a;
    }

    public void release() {
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public int getTextureUnits() {
        return 2;
    }

    public TexCoord2f map(float s, float t, int unit) {
        return unit == 0 ? new TexCoord2f(s, t) : new TexCoord2f(s * this.detailRepeat, t * this.detailRepeat);
    }
}

