/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.io.IOException;
import org.jagatoo.opengl.enums.TextureFilter;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoord2f;
import org.xith3d.loaders.shaders.impl.glsl.GLSLShaderLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.terrain.GridSurface;

class GLSLTerrainSurface
implements GridSurface {
    private float fogDistance = 40.0f;
    private float fogBoundary = 2000.0f;
    private float[] fogColor = new float[4];
    private Appearance appearance;

    private static final Texture loadTexture(String texName) {
        Texture2D texture = TextureLoader.getInstance().getTexture(texName, Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        texture.setFilter(TextureFilter.TRILINEAR);
        texture.enableAutoFreeLocalData();
        return texture;
    }

    public GLSLTerrainSurface(ResourceLocator resLoc, Colorf fogColor) throws IOException {
        fogColor.get(this.fogColor);
        Appearance a = new Appearance();
        Material mat = new Material();
        mat.setAmbientColor(Colorf.GRAY25);
        mat.setLightingEnabled(true);
        a.setMaterial(mat);
        TextureAttributes ta = new TextureAttributes(TextureAttributes.REPLACE, null, null, TextureAttributes.NICEST);
        TextureUnit surfaceColor = new TextureUnit(GLSLTerrainSurface.loadTexture("coast/coast-texture_2x2k.gif"), ta, null);
        TextureUnit surfaceNormals = new TextureUnit(GLSLTerrainSurface.loadTexture("coast/coast-texture_2x2k.gif"), ta, null);
        TextureUnit surfaceDetails = new TextureUnit(GLSLTerrainSurface.loadTexture("coast/coast-details.png"), ta, null);
        TextureUnit surfaceDetailNormals = new TextureUnit(GLSLTerrainSurface.loadTexture("coast/coast-texture_2x2k.gif"), ta, null);
        a.setTextureUnits(surfaceColor, surfaceNormals, surfaceDetails, surfaceDetailNormals);
        GLSLVertexShader vertexShader = GLSLShaderLoader.getInstance().loadVertexShader(resLoc.getResource("shader/coast/terrain-material.glslvert"));
        GLSLFragmentShader fragmentShader = GLSLShaderLoader.getInstance().loadFragmentShader(resLoc.getResource("shader/coast/terrain-material.glslfrag"));
        GLSLContext shaderProg = new GLSLContext(new GLSLShaderProgram(vertexShader, fragmentShader));
        GLSLParameters params = shaderProg.getUniformParameters();
        params.setUniformVar("Texture", 0);
        params.setUniformVar("Normals", 1);
        params.setUniformVar("Details", 2);
        params.setUniformVar("DetailNormals", 3);
        params.setUniformVar("LightPosition", 3, 10000.0f, 0.0f, 0.0f);
        params.setUniformVar("FogColor", 3, this.fogColor);
        params.setUniformVar("LightColor", 3, 1.0f, 1.0f, 1.0f);
        params.setUniformVar("SpecularFactor", 1.0f);
        params.setUniformVar("FogDistance", this.fogDistance);
        params.setUniformVar("FogBoundary", this.fogBoundary);
        params.setUniformVar("DetailBlending", 0.1f);
        a.setShaderProgramContext(shaderProg);
        this.appearance = a;
    }

    public void release() {
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public int getTextureUnits() {
        return 4;
    }

    public TexCoord2f map(float s, float t, int unit) {
        return new TexCoord2f(s, t);
    }
}

