/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xith3d.terrain.legacy.TerrainSampleInterface;

public class HeightMap
implements TerrainSampleInterface {
    private int scale = 3;
    private float[][] map;
    private int xDim;
    private int zDim;
    private float height;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeightMap(URL resource, int xDim, int zDim, float height) throws IOException {
        this.xDim = xDim;
        this.zDim = zDim;
        this.height = height;
        InputStream in = null;
        float[][] result = new float[xDim][zDim];
        try {
            in = resource.openStream();
            for (int z = 0; z < zDim; ++z) {
                for (int x = 0; x < xDim; ++x) {
                    int data = in.read();
                    if (data == -1) {
                        throw new IOException("EOF");
                    }
                    result[x][z] = (float)(data & 0xFF) / 255.0f;
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ignore) {}
        }
        this.map = result;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public int getScale() {
        return this.scale;
    }

    public float sample(int x, int z) {
        return this.map[x][z] * this.height;
    }

    public float getXOrg() {
        return 0.0f;
    }

    public float getZOrg() {
        return 0.0f;
    }

    public int getXDim() {
        return this.xDim;
    }

    public int getZDim() {
        return this.zDim;
    }
}

