/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import java.io.IOException;
import java.text.NumberFormat;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.RenderLoop;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.terrain.ChunkedTerrain;
import org.xith3d.terrain.L3DTerrain;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.borders.EmptyBorder;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A Test that shows how to load and display L3DT generated terrains."}, authors={"Mathias Henze (aka cylab)"})
public class L3DTTest
extends Xith3DTest {
    private NumberFormat highNF;
    private NumberFormat lowNF;
    private Xith3DEnvironment env;
    private FirstPersonInputHandler fpHandler;
    private RenderPass scenePass;
    private float movementSpeed = 50.0f;
    private float personSize = 1.8f;
    private boolean isFlying = true;
    private float minFPS = Float.MAX_VALUE;
    private float maxFPS = Float.MIN_VALUE;
    private Label movementSpeedLbl;
    private Label movementTypeLbl;
    private Label currentHeightLbl;
    private Label fpsLbl;
    private ChunkedTerrain terrain;

    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.fpHandler.setMouseMovementSuspended(false);
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
        float tmp = this.movementSpeed + (float)(wheelDelta * 10);
        if (tmp > 0.0f) {
            this.movementSpeed = tmp;
        }
        this.movementSpeedLbl.setText(this.movementSpeed);
        this.fpHandler.setMovementSpeed(this.movementSpeed / 36.0f);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                if (!this.fpHandler.isMouseMovementSuspended()) {
                    this.fpHandler.setMouseMovementSuspended(true);
                    break;
                }
                this.end();
                break;
            }
            case G: {
                this.scenePass.switchWireframeMode();
                break;
            }
            case F: {
                this.isFlying = !this.isFlying;
                this.movementTypeLbl.setText(this.isFlying ? "flying" : "walking");
                this.fpHandler.getMovementConstraints().setFixedPlaneEnabled(!this.isFlying);
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case R: {
                this.minFPS = Float.MAX_VALUE;
                this.maxFPS = Float.MIN_VALUE;
                break;
            }
            case SPACE: {
                if (this.fpHandler.isMouseMovementSuspended()) break;
                this.fpHandler.setMouseMovementSuspended(true);
            }
        }
    }

    private BranchGroup createScene(SceneGraph sceneGraph) throws IOException {
        BranchGroup root = new BranchGroup();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        this.terrain = new L3DTerrain(resLoc.getResource("terrain/l3dttest/l3dttest.proj"));
        root.addChild(this.terrain);
        AmbientLight ambient = new AmbientLight(Colorf.WHITE);
        root.addChild(ambient);
        sceneGraph.getView().lookAlong(new Point3f(0.0f, this.terrain.getHeight(), 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(0.0f, 1.0f, 0.0f));
        return root;
    }

    private void setupGui(Canvas3D canvas, SceneGraph sceneGraph) {
        HUDFont.setUseFontScaling(false);
        Panel panel = new Panel(true, 400.0f, 200.0f, new Colorf(0.3f, 0.3f, 0.3f, 0.5f));
        panel.setLocation(10.0f, 10.0f);
        HUD gui = new HUD((Sized2iRO)canvas, 1024.0f, (WidgetContainer)panel);
        panel.setBorder(new EmptyBorder(5));
        GridLayout layout = new GridLayout(10, 2);
        layout.setColWeights(0.6f, 0.4f);
        panel.setLayout(layout);
        panel.addWidget(new Label(120.0f, 16.0f, "ViewPosition:", Colorf.WHITE));
        panel.addWidget(new Label(100.0f, 16.0f, "0.00", Colorf.WHITE));
        panel.addWidget(new Label(120.0f, 16.0f, "ViewDirection:", Colorf.WHITE));
        panel.addWidget(new Label(100.0f, 16.0f, "0.00", Colorf.WHITE));
        panel.addWidget(new Label(120.0f, 16.0f, "MovementSpeed (MW):", Colorf.WHITE));
        this.movementSpeedLbl = new Label(100.0f, 16.0f, "", Colorf.WHITE);
        panel.addWidget(this.movementSpeedLbl);
        this.movementSpeedLbl.setText(this.movementSpeed);
        panel.addWidget(new Label(120.0f, 16.0f, "MovementType (f):", Colorf.WHITE));
        this.movementTypeLbl = new Label(100.0f, 16.0f, this.isFlying ? "flying" : "walking", Colorf.WHITE);
        panel.addWidget(this.movementTypeLbl);
        panel.addWidget(new Label(120.0f, 16.0f, "TerrainHeight:", Colorf.WHITE));
        this.currentHeightLbl = new Label(100.0f, 16.0f, "0.00", Colorf.WHITE);
        panel.addWidget(this.currentHeightLbl);
        panel.addWidget(new Label(120.0f, 16.0f, "FPS [min;curM;max] (r):", Colorf.WHITE));
        this.fpsLbl = new Label(100.0f, 16.0f, "0.00", Colorf.WHITE);
        panel.addWidget(this.fpsLbl);
        sceneGraph.addHUD(gui);
    }

    public L3DTTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        this.highNF = NumberFormat.getInstance();
        this.highNF.setMinimumIntegerDigits(4);
        this.highNF.setMinimumFractionDigits(2);
        this.highNF.setMaximumFractionDigits(2);
        this.lowNF = NumberFormat.getInstance();
        this.lowNF.setMinimumFractionDigits(2);
        this.lowNF.setMaximumFractionDigits(2);
        this.env = new Xith3DEnvironment(this);
        this.env.getView().setFrontClipDistance(0.2f);
        this.env.getView().setBackClipDistance(8000.0f);
        BranchGroup scene = this.createScene(this.env);
        this.scenePass = this.env.addPerspectiveBranch(scene);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.scenePass.getConfig().setRenderOptions(new RenderOptions(canvas.getRenderOptions()));
        this.scenePass.getConfig().getRenderOptions().setWireframeModeEnabled(false);
        this.setupGui(canvas, this.env);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.env.getView(), this.env.getCanvas(), 1.5f, 1.5f, arguments.getMouseYInverted(), this.movementSpeed / 36.0f);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(Keys.SPACE);
        this.fpHandler.getBindingsManager().unbind(MouseButtons.WHEEL_UP);
        this.fpHandler.getBindingsManager().unbind(MouseButtons.WHEEL_DOWN);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
        this.addFPSListener(new CanvasFPSListener(canvas){

            protected String getDynamicTitlePart(float fps, boolean limited) {
                if (fps < L3DTTest.this.minFPS) {
                    L3DTTest.this.minFPS = fps;
                }
                if (fps > L3DTTest.this.maxFPS) {
                    L3DTTest.this.maxFPS = fps;
                }
                L3DTTest.this.fpsLbl.setText(fps);
                return super.getDynamicTitlePart(fps, limited);
            }
        });
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                Point3f pos = L3DTTest.this.env.getView().getPosition();
                float ypos = pos.getY();
                if (L3DTTest.this.terrain != null) {
                    ypos = L3DTTest.this.terrain.pickY(pos.getX(), pos.getZ());
                    L3DTTest.this.currentHeightLbl.setText(ypos);
                }
                if (!L3DTTest.this.isFlying || pos.getY() < ypos + L3DTTest.this.personSize) {
                    pos.setY(ypos + L3DTTest.this.personSize);
                    L3DTTest.this.env.getView().setPosition(pos);
                }
            }
        });
        this.begin(RenderLoop.RunMode.RUN_IN_SAME_THREAD);
    }

    public static void main(String[] args) throws Throwable {
        L3DTTest test = new L3DTTest(L3DTTest.parseCommandLine(args));
        test.begin();
    }
}

