/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Transform;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.terrain.ChunkedTerrain;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridSurface;
import org.xith3d.terrain.HeightMapSampler;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.terrain.DetailTextureSurface;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Shows how to incorporate lights with a terrain"}, authors={"Mathias Henze (aka cylab)"})
public class LightedTerrainTest
extends Xith3DTest {
    private Xith3DEnvironment env;
    private FirstPersonInputHandler fpHandler;
    private Canvas3D canvas;
    private GridSampler heightMap;
    private GridSurface surface;
    private float tolerance = 0.01f;
    private float bias = 7.0f;
    private float x = -10000.0f / this.bias;
    private float z = -10000.0f / this.bias;
    private float scale = 20000.0f / this.bias;
    private float height = 4000.0f / this.bias;
    private float movementSpeed = this.scale / 150.0f;
    private PointLight pLight;
    private Tuple3f attenuation = new Tuple3f();
    private int attComp = 0;

    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.fpHandler.setMouseMovementSuspended(false);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case NUMPAD_DIVIDE: 
            case NUMPAD_MULTIPLY: {
                if (key == Keys.NUMPAD_DIVIDE) {
                    --this.attComp;
                    if (this.attComp == -1) {
                        this.attComp = 2;
                    }
                } else {
                    this.attComp = (this.attComp + 1) % 3;
                }
                System.out.print("Currently manipulating ");
                switch (this.attComp) {
                    case 0: {
                        System.out.println("Constant Attenuation.");
                        break;
                    }
                    case 1: {
                        System.out.println("Linear Attenuation.");
                        break;
                    }
                    case 2: {
                        System.out.println("Quadric Attenuation.");
                    }
                }
                break;
            }
            case NUMPAD_ADD: {
                float newValue = this.attenuation.getValue(this.attComp) + 0.01f;
                if (!(newValue > 0.0f) || !(newValue < 1.0f)) break;
                this.attenuation.setValue(this.attComp, newValue);
                this.pLight.setAttenuation(this.attenuation);
                System.out.println("Current Attenuation: " + this.attenuation);
                break;
            }
            case NUMPAD_SUBTRACT: {
                float newValue2 = this.attenuation.getValue(this.attComp) - 0.01f;
                if (!(newValue2 > 0.0f) || !(newValue2 < 1.0f)) break;
                this.attenuation.setValue(this.attComp, newValue2);
                this.pLight.setAttenuation(this.attenuation);
                System.out.println("Current Attenuation: " + this.attenuation);
                break;
            }
            case G: {
                this.canvas.switchWireframeMode();
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case SPACE: {
                if (this.fpHandler.isMouseMovementSuspended()) break;
                this.fpHandler.setMouseMovementSuspended(true);
                break;
            }
            case ESCAPE: {
                if (!this.fpHandler.isMouseMovementSuspended()) {
                    this.fpHandler.setMouseMovementSuspended(true);
                    break;
                }
                this.end();
            }
        }
    }

    private BranchGroup createScene(ResourceLocator resLoc) {
        BranchGroup root = new BranchGroup();
        try {
            this.heightMap = new HeightMapSampler(resLoc.getResource("terrain/coast/coast-heightfield_1x1k_16bit.raw"), 1024, 1024, HeightMapSampler.Type.RAW_16);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        Material material = new Material();
        material.setAmbientColor(Colorf.GRAY75);
        material.setShininess(0.0f);
        material.setLightingEnabled(true);
        this.surface = new DetailTextureSurface("testpattern.png", material);
        ChunkedTerrain chunkedTerrain = new ChunkedTerrain(this.heightMap, this.surface, this.x, 0.0f, this.z, this.scale, this.height);
        root.addChild(chunkedTerrain);
        Point3f lightPos = new Point3f(0.0f, 450.0f, 0.0f);
        Colorf lightColor = new Colorf(0.95f, 1.0f, 0.8f);
        Sphere lightAvatar = new Sphere(5.0f, 16, 16, lightColor);
        Transform lightTranslation = new Transform();
        final Transform lightRotation = new Transform();
        lightRotation.setTranslation(lightPos);
        lightRotation.add(lightTranslation);
        lightTranslation.setTranslation(150.0f, 0.0f, 0.0f);
        lightTranslation.add(lightAvatar);
        root.addChild(lightRotation);
        this.attenuation.set(1.0f, 0.008f, 1.0E-5f);
        this.pLight = new PointLight(lightColor, (Tuple3f)Point3f.ZERO, this.attenuation);
        this.pLight.setEnabled(true);
        root.addChild(this.pLight);
        this.pLight.setTrackedNode(lightAvatar);
        this.addUpdatable(new Updatable(){

            public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                lightRotation.addRotationY(timingMode.getSecondsAsFloat(frameTime) * (float)Math.PI / 4.0f);
            }
        });
        AmbientLight ambient = new AmbientLight(Colorf.WHITE);
        root.addChild(ambient);
        return root;
    }

    public LightedTerrainTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        up.normalize();
        this.env = new Xith3DEnvironment(new Point3f(50.0f, 750.0f, 250.0f), new Point3f(0.0f, 300.0f, 0.0f), up, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        resLoc.createAndAddTSL("terrain");
        BranchGroup scene = this.createScene(resLoc);
        this.env.addPerspectiveBranch(scene);
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.env.addCanvas(this.canvas);
        this.canvas.setWireframeMode(false);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.env.getView(), this.env.getCanvas(), 1.5f, 1.5f, arguments.getMouseYInverted(), this.movementSpeed);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        this.fpHandler.getBindingsManager().unbind(Keys.SPACE);
        InputSystem.getInstance().addInputHandler(this.fpHandler);
        this.addFPSListener(new CanvasFPSListener(this.canvas){

            protected String getDynamicTitlePart(float fps, boolean limited) {
                return super.getDynamicTitlePart(fps, limited) + ", tolerance: " + LightedTerrainTest.this.tolerance;
            }
        });
    }

    public static void main(String[] args) throws Throwable {
        LightedTerrainTest test = new LightedTerrainTest(LightedTerrainTest.parseCommandLine(args));
        test.begin();
    }
}

