/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.utils.GeomDrawUtil;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.terrain.legacy.Terrain;
import org.xith3d.terrain.legacy.TerrainRenderInterface;
import org.xith3d.terrain.legacy.TerrainSampleInterface;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.AbstractButton;
import org.xith3d.ui.hud.listeners.ButtonListener;
import org.xith3d.ui.hud.listeners.ScrollbarListener;
import org.xith3d.ui.hud.widgets.Button;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.hud.widgets.Scrollbar;
import org.xith3d.ui.hud.widgets.ToggleButton;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.noise.Noise;
import org.xith3d.utility.noise.Perlin2;

@Xith3DTest.Description(fulltext={"Simple Xith3D tarrain test"}, authors={"Yuri Vl. Gushchin (aka YVG)", "Marvin Froehlich (aka Qudus)", "Amos Wenger (aka BlueSky)"})
public class TerrainTest
extends Xith3DTest {
    private static final float HEIGHT = 200.0f;
    private Terrain terrain;
    private TerrainShape terrainShape;
    private Light light;
    private Material material;
    private View view;
    private float speed = 4.0f;
    private static final float MAX_HEIGHT = 600.0f;
    private Point3f position = new Point3f(20.0f, 20.0f, 20.0f);
    private Point3f lookat = new Point3f();
    private float distance = 20.0f;
    private Transform3D viewT = new Transform3D();
    private Point3f lastUpdate = new Point3f(0.0f, 0.0f, 0.0f);
    private float direction = 1.0f;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    private BranchGroup createSceneGraph(Animator animator) {
        BranchGroup scene = new BranchGroup();
        RotatableGroup testRotateYGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        TransformGroup scaleTransform = new TransformGroup();
        testRotateYGroup.addChild(scaleTransform);
        this.light = new AmbientLight(true, Colorf.BLUE);
        scaleTransform.addChild(this.light);
        Texture2D texture = TextureLoader.getInstance().getTexture("stone.jpg");
        this.material = new Material();
        this.material.setAmbientColor(Colorf.GRAY25);
        this.material.setLightingEnabled(true);
        Appearance a = new Appearance();
        a.setPolygonAttributes(new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK));
        a.setTexture(texture);
        a.setMaterial(this.material);
        Cube cube = new Cube(0.8f, a);
        StaticTransform.translate(cube, 0.0f, 0.0f, -0.5f);
        scaleTransform.addChild(cube);
        scene.addChild(testRotateYGroup);
        animator.addAnimatableObject(testRotateYGroup);
        return scene;
    }

    private TerrainShape buildTerrain(View view) {
        this.terrain = new Terrain(12, 10);
        System.out.println("Building terrain...");
        this.terrain.addData(new TerrainManager());
        System.out.println("Nodes = " + this.terrain.CountNodes());
        System.out.println("Removing nodes which are irrelevent...");
        System.out.println("Nodes count before culling = " + this.terrain.CountNodes());
        this.terrain.cullStaticData(40.0f, 4);
        System.out.println("Nodes count after culling = " + this.terrain.CountNodes());
        this.terrainShape = new TerrainShape();
        this.terrainShape.rebuild(view);
        return this.terrainShape;
    }

    private void createHUD(Sized2iRO canvasRes, SceneGraph sceneGraph) {
        TestHUD hud = new TestHUD(canvasRes);
        sceneGraph.addHUD(hud);
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        if (this.position.getX() > 4000.0f) {
            this.position.setX(4000.0f);
            this.position.setZ(4000.0f);
            this.direction = -1.0f;
        } else if (this.position.getX() < 0.0f) {
            this.position.setX(0.0f);
            this.position.setZ(0.0f);
            this.direction = 1.0f;
        }
        this.position.addX(this.speed * this.direction);
        this.position.addZ(this.speed * this.direction);
        this.position.setY(this.terrain.getY(this.position.getX(), this.position.getZ()) + 200.0f);
        this.lookat.set((TupleNf)this.position);
        this.lookat.addX(this.distance * this.direction);
        this.lookat.addZ(this.distance * this.direction);
        this.lookat.setY(this.terrain.getY(this.lookat.getX(), this.lookat.getZ()) + 200.0f);
        this.viewT.lookAt(this.position, this.lookat, Vector3f.POSITIVE_Y_AXIS);
        this.view.setTransform(this.viewT);
        if (this.lastUpdate.distance(this.position) > 200.0f) {
            this.terrainShape.rebuild(this.view);
            this.lastUpdate.set((TupleNf)this.position);
        }
    }

    public TerrainTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(100.0f, 300.0f, 100.0f, 2000.0f, 100.0f, 2000.0f, 0.0f, 1.0f, 0.0f, this);
        this.view = env.getView();
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        RenderPass renderPass = env.addPerspectiveBranch(this.createSceneGraph(this.getAnimator()));
        renderPass.getConfig().setFrontClipDistance(1.0f);
        renderPass.getConfig().setBackClipDistance(8000.0f);
        this.terrainShape = this.buildTerrain(this.view);
        renderPass.getBranchGroup().addChild(this.terrainShape);
        this.createHUD(arguments.getResolution(), env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        System.out.println("Hit SPACE to toggle projection policy, or ESC to exit");
    }

    public static void main(String[] args) throws Throwable {
        TerrainTest test = new TerrainTest(TerrainTest.parseCommandLine(args));
        test.begin();
    }

    class TestHUD
    extends HUD {
        public TestHUD(Sized2iRO canvasRes) {
            super(canvasRes, 1024.0f);
            Panel panel = new Panel(200.0f, 200.0f);
            ToggleButton lightButton = new ToggleButton(160.0f, 35.0f, "Light");
            lightButton.setToggled(true);
            panel.addWidget(lightButton, 20.0f, 20.0f);
            lightButton.addButtonListener(new ButtonListener(){

                public void onButtonClicked(AbstractButton button, Object userObject) {
                    boolean lightEnabled = ((ToggleButton)button).isToggled();
                    TerrainTest.this.light.setEnabled(lightEnabled);
                    TerrainTest.this.material.setLightingEnabled(lightEnabled);
                }
            });
            ToggleButton wireframeButton = new ToggleButton(160.0f, 35.0f, "Wireframe");
            wireframeButton.setToggled(false);
            panel.addWidget(wireframeButton, 20.0f, 65.0f);
            wireframeButton.addButtonListener(new ButtonListener(){

                public void onButtonClicked(AbstractButton button, Object userObject) {
                    TerrainTest.this.terrainShape.setLineMode(((ToggleButton)button).isToggled());
                }
            });
            Button exitButton = new Button(160.0f, 35.0f, "Exit");
            panel.addWidget(exitButton, 20.0f, 110.0f);
            exitButton.addButtonListener(new ButtonListener(){

                public void onButtonClicked(AbstractButton button, Object userObject) {
                    TerrainTest.this.end();
                }
            });
            Scrollbar speedSlider = new Scrollbar(160.0f, Scrollbar.Direction.HORIZONTAL);
            speedSlider.setMinMaxAndValue(1, 10, 1);
            panel.addWidget(speedSlider, 20.0f, 155.0f);
            speedSlider.addScrollbarListener(new ScrollbarListener(){

                public void onScrollbarValueChanged(Scrollbar scrollbar, int newValue) {
                    TerrainTest.this.speed = newValue;
                }
            });
            this.getContentPane().addWidget(panel, 30.0f, 30.0f);
        }
    }

    private class TerrainManager
    implements TerrainSampleInterface {
        private int scale = 3;
        private Perlin2 perlin = new Perlin2(1, 0.5, 2.0, 2.0, 1.0, 0.0, new Noise());

        public int getScale() {
            return this.scale;
        }

        public float sample(int x, int z) {
            return (float)(this.perlin.value((float)x / 1400.0f, (float)z / 1400.0f) + 1.0) * 600.0f;
        }

        public float getXOrg() {
            return 0.0f;
        }

        public float getZOrg() {
            return 0.0f;
        }

        public int getXDim() {
            return 8000;
        }

        public int getZDim() {
            return 8000;
        }
    }

    private class TerrainShape
    extends Group
    implements TerrainRenderInterface {
        private static final int MAX_INDICES = 20000;
        private static final int MAX_VERTICES = 30000;
        private int totalIndex = 0;
        private int totalVerts = 0;
        private Shape3D shape;
        private IndexedTriangleArray geo;
        private GeomDrawUtil drawer;
        private int[] index = new int[20000];
        private int[] vertexMap = new int[100];
        private PolygonAttributes pa;

        public TerrainShape() {
            this.geo = new IndexedTriangleArray(30000, 20000);
            this.drawer = new GeomDrawUtil(this.geo);
            Appearance a = new Appearance();
            this.pa = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK);
            a.setPolygonAttributes(this.pa);
            this.shape = new Shape3D(this.geo, a);
            this.shape.setBoundsAutoCompute(false);
            this.shape.setBounds(new BoundingSphere(Point3f.ZERO, 100000.0f));
            this.addChild(this.shape);
        }

        public void setLineMode(boolean yes) {
            if (yes) {
                this.pa.setDrawMode(DrawMode.LINE);
            } else {
                this.pa.setDrawMode(DrawMode.FILL);
            }
        }

        public void rebuild(View view) {
            Point3f point = new Point3f();
            view.getTransform().get(point);
            TerrainTest.this.terrain.update(point, 117.0f);
            this.drawer.drawStart();
            this.totalIndex = 0;
            this.totalVerts = 0;
            TerrainTest.this.terrain.render(this);
            System.out.println("total vertices = " + this.totalVerts);
            System.out.println("total indices = " + this.totalIndex);
            this.drawer.drawEnd();
            this.geo.setIndex(this.index);
            this.geo.setValidIndexCount(this.totalIndex);
            this.geo.setValidVertexCount(this.totalVerts);
        }

        public void start() {
        }

        public void initVert(int i, float x, float y, float z) {
            if (this.totalVerts >= 30000) {
                return;
            }
            this.drawer.newVertex();
            this.drawer.setCoordinate(x, y, z);
            float c = y / 1200.0f;
            this.drawer.setColor(c, c, c);
            ++this.totalVerts;
        }

        public void tri(int a, int b, int c) {
            if (this.totalIndex + 3 >= 20000) {
                return;
            }
            this.index[this.totalIndex++] = this.vertexMap[a];
            this.index[this.totalIndex++] = this.vertexMap[b];
            this.index[this.totalIndex++] = this.vertexMap[c];
        }

        public void done() {
        }
    }
}

