/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.terrain;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Interval;
import org.xith3d.loop.opscheduler.IntervalListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.IndexedTriangleStripArray;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.primitives.Line;
import org.xith3d.terrain.GridSampler;
import org.xith3d.terrain.GridTriangulator;
import org.xith3d.terrain.HeightMapSampler;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"And yet another TerrainTest :)"}, authors={"Mathias Henze (aka cylab)"})
public class TerrainTest4
extends Xith3DTest
implements GridTriangulator.IndexCallback {
    private Xith3DEnvironment env;
    private FirstPersonInputHandler fpHandler;
    private Canvas3D canvas;
    private ResourceLocator resLoc;
    private GridSampler heightMap;
    private IndexedTriangleStripArray geometry;
    private GridTriangulator triangulator;
    private boolean continuous = false;
    private float baseTolerance = 0.1f;
    private float tolerance = 0.16f;
    private Interval interval = new Interval(100L);
    private int threshold = 150;
    private float height = 30.0f;
    private int complexity = 8;
    private boolean calculatingIndex = false;
    private int[] nextIndex = null;

    protected void exit() {
        this.fpHandler.setMouseMovementSuspended(true);
        super.exit();
    }

    protected void onFPSCountIntervalHit(float fps) {
        super.onFPSCountIntervalHit(fps);
        this.canvas.setTitle("TerrainTest4 (fps: " + (int)fps + "), tolerance: " + this.tolerance);
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.fpHandler.setMouseMovementSuspended(false);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                if (!this.fpHandler.isMouseMovementSuspended()) {
                    this.fpHandler.setMouseMovementSuspended(true);
                    break;
                }
                this.end();
                break;
            }
            case G: {
                this.canvas.switchWireframeMode();
                break;
            }
            case Y: {
                this.fpHandler.flipMouseYAxis();
                break;
            }
            case O: {
                int[] index = this.triangulator.getIndex(this.tolerance, this.env.getView().getPosition(), 128.0f);
                this.geometry.setIndex(index);
                this.geometry.setValidIndexCount(index.length);
                System.out.println("Number of indicies: " + index.length);
                break;
            }
            case C: {
                this.continuous = !this.continuous;
                break;
            }
            case NUMPAD_ADD: {
                this.tolerance -= 0.02f;
                if (this.tolerance < 0.0f) {
                    this.tolerance = 0.0f;
                }
                int[] index = this.triangulator.getIndex(this.tolerance);
                this.geometry.setIndex(index);
                this.geometry.setValidIndexCount(index.length);
                System.out.println("Number of indicies: " + index.length);
                break;
            }
            case NUMPAD_SUBTRACT: {
                this.tolerance += 0.02f;
                int[] index = this.triangulator.getIndex(this.tolerance);
                this.geometry.setIndex(index);
                this.geometry.setValidIndexCount(index.length);
                System.out.println("Number of indicies: " + index.length);
                break;
            }
            case SPACE: {
                if (this.fpHandler.isMouseMovementSuspended()) break;
                this.fpHandler.setMouseMovementSuspended(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFinished(int[] index) {
        TerrainTest4 terrainTest4 = this;
        synchronized (terrainTest4) {
            this.nextIndex = index;
            this.calculatingIndex = false;
        }
    }

    private BranchGroup createScene() {
        BranchGroup root = new BranchGroup();
        try {
            this.heightMap = new HeightMapSampler(this.resLoc.getResource("terrain/terrain-height.raw"), 257, 257);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        Appearance a = new Appearance();
        Texture2D texture = TextureLoader.getInstance().getTexture("terrain-splat.png", Texture.MipmapMode.MULTI_LEVEL_MIPMAP);
        Material mat = new Material();
        mat.setAmbientColor(Colorf.GRAY25);
        mat.setLightingEnabled(true);
        a.setMaterial(mat);
        a.setTexture(texture);
        this.triangulator = new GridTriangulator(this.heightMap, this.complexity, this.height);
        this.triangulator.setBaseTolerance(this.baseTolerance);
        System.out.println("Number of vertices: " + this.triangulator.getSize() * this.triangulator.getSize());
        Tuple3f[] coordinates = this.triangulator.getCoordinates();
        int[] index = this.triangulator.getIndex();
        System.out.println("Number of vertices after optimization: " + coordinates.length);
        System.out.println("Number of indicies: " + index.length);
        this.geometry = new IndexedTriangleStripArray(coordinates.length, index.length);
        this.geometry.setCoordinates(0, coordinates);
        this.geometry.setIndex(index);
        this.geometry.setValidIndexCount(index.length);
        Shape3D terrainShape = new Shape3D(this.geometry, a);
        root.addChild(terrainShape);
        root.addChild(new Line((Tuple3f)Vector3f.ZERO, Vector3f.POSITIVE_X_AXIS, Colorf.RED));
        root.addChild(new Line((Tuple3f)Vector3f.ZERO, Vector3f.POSITIVE_Y_AXIS, Colorf.GREEN));
        root.addChild(new Line((Tuple3f)Vector3f.ZERO, Vector3f.POSITIVE_Z_AXIS, Colorf.BLUE));
        AmbientLight ambient = new AmbientLight(Colorf.WHITE);
        root.addChild(ambient);
        return root;
    }

    public TerrainTest4(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        up.normalize();
        this.env = new Xith3DEnvironment(new Vector3f(0.0f, this.height, 0.0f), new Vector3f(0.0f, 0.0f, this.height * 2.0f), up, this);
        this.resLoc = TestUtils.createResourceLocator();
        this.resLoc.createAndAddTSL("textures");
        this.resLoc.createAndAddTSL("terrain");
        this.env.addPerspectiveBranch(this.createScene());
        this.getOperationScheduler().addInterval(this.interval);
        this.getOperationScheduler().addIntervalListener(new IntervalListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onIntervalHit(Interval interval, long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
                if (TerrainTest4.this.continuous) {
                    TerrainTest4 terrainTest4 = TerrainTest4.this;
                    synchronized (terrainTest4) {
                        if (!TerrainTest4.this.calculatingIndex) {
                            if (TerrainTest4.this.nextIndex != null) {
                                TerrainTest4.this.geometry.setIndex(TerrainTest4.this.nextIndex);
                                TerrainTest4.this.geometry.setValidIndexCount(TerrainTest4.this.nextIndex.length);
                                System.out.println("Number of indicies: " + TerrainTest4.this.nextIndex.length);
                                TerrainTest4.access$202(TerrainTest4.this, null);
                            } else {
                                TerrainTest4.this.calculatingIndex = true;
                                TerrainTest4.this.triangulator.getIndex(TerrainTest4.this.tolerance, TerrainTest4.this.env.getView().getPosition(), TerrainTest4.this.threshold, TerrainTest4.this);
                            }
                        }
                    }
                }
            }
        });
        this.canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        this.canvas.setWireframeMode(false);
        this.env.addCanvas(this.canvas);
        this.canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(this.canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(this.canvas.getPeer());
        this.fpHandler = new FirstPersonInputHandler((Transformable)this.env.getView(), this.env.getCanvas(), 1.5f, 1.5f, arguments.getMouseYInverted(), 1.5f);
        this.fpHandler.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(this.fpHandler);
    }

    public static void main(String[] args) throws Throwable {
        TerrainTest4 test = new TerrainTest4(TerrainTest4.parseCommandLine(args));
        test.begin();
    }

    static /* synthetic */ int[] access$202(TerrainTest4 x0, int[] x1) {
        x0.nextIndex = x1;
        return x1;
    }
}

