/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.test.texture;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.FastMath;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.primitives.Rectangle;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"A simple testcase for loading BMP Textures."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BMPTextureTest
extends Xith3DTest {
    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
                break;
            }
        }
    }

    private RenderPass createScene() throws Exception {
        Texture2D tex = TextureLoader.getInstance().getTexture("normalmap.bmp", Texture.MipmapMode.BASE_LEVEL);
        Rectangle rect = new Rectangle(128.0f, 128.0f, Rectangle.ZeroPointLocation.TOP_LEFT, (Texture)tex);
        StaticTransform.translate(rect, 100.0f, -100.0f, 0.0f);
        RenderPass renderPass = RenderPass.create2D(800, 600);
        renderPass.getBranchGroup().addChild(rect);
        return renderPass;
    }

    public BMPTextureTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        env.getView().setFieldOfView(FastMath.toRad(35.0f));
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        env.addRenderPass(this.createScene());
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BMPTextureTest test = new BMPTextureTest(BMPTextureTest.parseCommandLine(args));
        test.begin();
    }
}

